/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 10/04/2022
 */

#include "json_.h"

struct stub_JData_new_list:public pylib::Member_def<json::JData>
{
    pylib::Objref *def(json::JData *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JList *list=args.get<json::JList *>(1);
            instance->new_list(label,list);
            return pylib::retnone();
        }
        else if(args.size() == 3)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JList *list=args.get<json::JList *>(1);
            vmp::str jtype=args.get<vmp::str>(2);
            instance->new_list(label,list,jtype);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_JData_set_list:public pylib::Member_def<json::JData>
{
    pylib::Objref *def(json::JData *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JList *list=args.get<json::JList *>(1);
            instance->set_list(label,list);
            return pylib::retnone();
        }
        else if(args.size() == 3)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JList *list=args.get<json::JList *>(1);
            vmp::str jtype=args.get<vmp::str>(2);
            instance->set_list(label,list,jtype);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_JData_get_list:public pylib::Member_def<json::JData>
{
    pylib::Objref *def(json::JData *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JList *list=args.get<json::JList *>(1);
            instance->get_list(label,list);
            return pylib::retnone();
        }
        else if(args.size() == 3)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JList *list=args.get<json::JList *>(1);
            vmp::str jtype=args.get<vmp::str>(2);
            instance->get_list(label,list,jtype);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_JData_new_table:public pylib::Member_def<json::JData>
{
    pylib::Objref *def(json::JData *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JTable *table=args.get<json::JTable *>(1);
            instance->new_table(label,table);
            return pylib::retnone();
        }
        else if(args.size() == 3)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JTable *table=args.get<json::JTable *>(1);
            vmp::str jtype=args.get<vmp::str>(2);
            instance->new_table(label,table,jtype);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_JData_set_table:public pylib::Member_def<json::JData>
{
    pylib::Objref *def(json::JData *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JTable *table=args.get<json::JTable *>(1);
            instance->set_table(label,table);
            return pylib::retnone();
        }
        else if(args.size() == 3)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JTable *table=args.get<json::JTable *>(1);
            vmp::str jtype=args.get<vmp::str>(2);
            instance->set_table(label,table,jtype);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_JData_get_table:public pylib::Member_def<json::JData>
{
    pylib::Objref *def(json::JData *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JTable *table=args.get<json::JTable *>(1);
            instance->get_table(label,table);
            return pylib::retnone();
        }
        else if(args.size() == 3)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JTable *table=args.get<json::JTable *>(1);
            vmp::str jtype=args.get<vmp::str>(2);
            instance->get_table(label,table,jtype);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_JData_set_vars:public pylib::Member_def<json::JData>
{
    pylib::Objref *def(json::JData *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str label=args.get<vmp::str>(0);
            vmp::Table<vmp::str,vmp::str> vars;
            args.get_table<vmp::str,vmp::str>(1,&vars);
            instance->set_vars(label,&vars);
            return pylib::retnone();                      
        }
        return 0;
    }
};

struct stub_JData_get_vars:public pylib::Member_def<json::JData>
{
    pylib::Objref *def(json::JData *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str label=args.get<vmp::str>(0);
            vmp::Table<vmp::str,vmp::str> vars;
            instance->get_vars(label,&vars);
            return pylib::Converter_table<vmp::str,vmp::str>(&vars);
        }
        return 0;
    }
};

struct stub_JData_set_subtype:public pylib::Member_def<json::JData>
{
    pylib::Objref *def(json::JData *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            instance->set_subtype(label,jdata);
            return pylib::retnone();                      
        }
        else if(args.size() == 3)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            vmp::str jtype=args.get<vmp::str>(2);
            instance->set_subtype(label,jdata,jtype);
            return pylib::retnone(); 
        }
        return 0;
    }
};

struct stub_JData_get_subtype:public pylib::Member_def<json::JData>
{
    pylib::Objref *def(json::JData *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            instance->get_subtype(label,jdata);
            return pylib::retnone();                      
        }
        else if(args.size() == 3)
        {
            vmp::str label=args.get<vmp::str>(0);
            json::JsonObj *jdata=args.get<json::JsonObj *>(1);
            vmp::str jtype=args.get<vmp::str>(2);
            instance->get_subtype(label,jdata,jtype);
            return pylib::retnone(); 
        }
        return 0;
    }
};

void json_jdata(pylib::Module module)
{
    pylib::Class<json::JData> jdata=module.class_<json::JData>("JData");
    jdata.def_("reset",&json::JData::reset);
    jdata.def_("new_data",&json::JData::new_data);
    jdata.def_("set",&json::JData::set);
    jdata.def_("remove_data",&json::JData::remove_data);
    jdata.def_("root",&json::JData::root,false);
    jdata.def_("jtype",&json::JData::jtype);
    jdata.def_("set_text",&json::JData::set_text);
    jdata.def_("get_text",&json::JData::get_text);
    jdata.def_("set_integer",&json::JData::set_integer);
    jdata.def_("get_integer",&json::JData::get_integer);
    jdata.def_("set_integer_range",&json::JData::set_integer_range);
    jdata.def_("get_integer_range",&json::JData::get_integer_range);
    jdata.def_("set_real",&json::JData::set_real);
    jdata.def_("get_real",&json::JData::get_real);
    jdata.def_("set_real_range",&json::JData::set_real_range);
    jdata.def_("get_real_range",&json::JData::get_real_range);
    jdata.def_("set_bool",&json::JData::set_bool);
    jdata.def_("get_bool",&json::JData::get_bool);
    jdata.def_with_stub("new_list",stub_JData_new_list());
    jdata.def_with_stub("set_list",stub_JData_set_list());
    jdata.def_with_stub("get_list",stub_JData_get_list());
    jdata.def_with_stub("new_table",stub_JData_new_table());
    jdata.def_with_stub("set_table",stub_JData_set_table());
    jdata.def_with_stub("get_table",stub_JData_get_table());
    jdata.def_("set_args",&json::JData::set_args);
    jdata.def_("get_args",&json::JData::get_args);
    jdata.def_with_stub("set_vars",stub_JData_set_vars());
    jdata.def_with_stub("get_vars",stub_JData_get_vars());
    jdata.def_("set_custom",&json::JData::set_custom);
    jdata.def_("get_custom",&json::JData::get_custom);
    jdata.def_with_stub("set_subtype",stub_JData_set_subtype());
    jdata.def_with_stub("get_subtype",stub_JData_get_subtype());
    jdata.def_("set_buf",&json::JData::set_buf);
    jdata.def_("get_buf",&json::JData::get_buf);
    jdata.def_("set_netaddress",&json::JData::set_netaddress);
    jdata.def_("get_netaddress",&json::JData::get_netaddress);
    jdata.def_("set_macaddress",&json::JData::set_macaddress);
    jdata.def_("get_macaddress",&json::JData::get_macaddress);
    jdata.def_("set_packet",&json::JData::set_packet);
    jdata.def_("get_packet",&json::JData::get_packet,false);
}

