/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 10/08/2021
 */

#include "vmp.h"
#include "pylib.h"
#include "event.h"

#ifndef VAMPIRIA_PY_EVENT_H

#define VAMPIRIA_PY_EVENT_H 1

//!Python wrapper of the c++ class vampiria::event::Manager in vmp_event.Manager(see c++ doc)
/*!
    Manager class in event.h:<BR>Constructor Manager()<BR>
    Manager member function list:<BR>init(),lock(),unlock(),time_now(),breakloop(),stop(),loop()
*/
void event_init_manager(pylib::Module module);

//!Python wrapper of the c++ class vampiria::event::Cell in vmp_event.Cell(see c++ doc)
/*! 
    enum wrapper CELLRET(return close status cell) c++ in event.h":<BR>CELLRET_NOCLOSE,CELLRET_SUCCESS,CELLRET_ERROR,CELLRET_TIMEOUT
*/
/*!
    Cell class in event.h:<BR>No Constructor<BR>
    Cell member function list:<BR>identity(),close(),close_wait(),close_err(),alloc(),release(),ret,str_error(),
                                  set_timewait(),get_timewait(),get_manager(),setvar(),getvar(),remvar(),all_keys()
*/
void event_init_cell(pylib::Module module);

//!Python wrapper of the c++ class vampiria::event::InputUI in vmp_event.InputUI(see c++ doc)
/*!
    Wrapper Cell->ui() for input in inputui(cell)<BR>
    @return user interface input ui for cell.(The cell must be built with the InputUI user interface)
*/
/*!
   InputUI Class in event/ui/inputui.h:<BR>Constructor InputUI(manager)<BR>
   InputUI member function list:<BR>set_event(),input()
*/
void event_init_inputui(pylib::Module module);

//!Python wrapper of the c++ class vampiria::event::TimerUI in vmp_event.TimerUI(see c++ doc)
/*!
    Wrapper Cell->ui() for input in timerui(cell)<BR>
    @return user interface input ui for cell.(The cell must be built with the TimerUI user interface)
*/
/*!
   TimerUI Class in event/ui/timerui.h:<BR>Constructor TimerUI(manager)<BR>
   InputUI member function list:<BR>set_event(),new_timer(),active_timer(),deactive_timer(),get_timeval(),id()
*/
void event_init_timerui(pylib::Module module);

//!Python wrapper of the c++ class vampiria::event::SimplexUI in vmp_event.SimplexUI(see c++ doc)
/*!
    Wrapper Cell->ui() for input in simplexui(cell)<BR>
    @return user interface input ui for cell.(The cell must be built with the SimplexUI user interface)
*/
/*!
    SimplexUI Class in event/ui/simplexui.h:<BR>Constructor SimplexUI(manager)<BR>
    SimplexUI member function list:<BR>set_event(),new_event(),active(),id()
*/
void event_init_simplexui(pylib::Module module);

//!Python wrapper of the c++ class vampiria::event::ThreadUI in vmp_event.ThreadUI(see c++ doc)
/*!
    Wrapper Cell->ui() for thread in threadui(cell)<BR>
    @return user interface thread ui for cell.(The cell must be built with the ThreadUI user interface)
*/
/*!
   InputUI Class in event/ui/threadui.h:<BR>Constructor InputUI(manager)<BR>
   InputUI member function list:<BR>set_event(),new_thread(),start_thread(),id()
*/
void event_init_threadui(pylib::Module module);

#endif


