#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 04/04/2020

import vmplib    as lib
import vmppylib  as pylib
import vmpsys    as sys
import vmpconfig as config

lib.included_.append(sys.path(config.gpkg_))

xterm0=lib.clib()
xterm0.name='xterm0'
xterm0.dependencies=['vmp']
xterm0.pkg=True
xterm0.files=[('xterm/',['xterm'])]
xterm0.cmd=['xterm -h']
lib.clibs_[xterm0.name]=xterm0

rawnet1=lib.clib()
rawnet1.name='rawnet1'
rawnet1.dependencies=['vmp','packet','event','net']
rawnet1.pkg=True
rawnet1.files=[('rawnet/',['lib','rawnet','rawevent','rawui'])]
rawnet1.libs=[('libpcap','1.10.0')]
rawnet1.coptions=['`pkg-config --cflags libpcap`']
rawnet1.loptions=['`pkg-config --libs  libpcap`']
lib.clibs_[rawnet1.name]=rawnet1

openssl0=lib.clib()
openssl0.name='openssl0'
openssl0.dependencies=['vmp','net']
openssl0.pkg=True
openssl0.files=[('openssl/',['lib','openssl','x509','pkey','sslevent','sslui'])]
openssl0.libs=[('openssl','1.1.1k')]
openssl0.loptions=['`pkg-config --libs  openssl`']
lib.clibs_[openssl0.name]=openssl0

openssl1=lib.clib()
openssl1.name='openssl1'
openssl1.dependencies=['vmp','net']
openssl1.pkg=True
openssl1.cmd=['openssl version','chmod --version','cp --version']
openssl1.files=[('openssl/',['lib','hash','openssl','x509','pkey','sslevent','sslui']),('openssl/ctx/',['ctx','base','peer'])]
openssl1.libs=[('openssl','1.1.1k')]
openssl1.loptions=['`pkg-config --libs  openssl`']
lib.clibs_[openssl1.name]=openssl1

vmp_xterm0=pylib.pylib()
vmp_xterm0.name='vmp_xterm0'
vmp_xterm0.dependencies=[]
vmp_xterm0.pkg=True
vmp_xterm0.cbuild()
vmp_xterm0.setup.files=[('./',['xterm_'])]
vmp_xterm0.setup.dependencies=['pylib','xterm0','vmp']
pylib.pylibs_[vmp_xterm0.name]=vmp_xterm0

vmp_gui0=pylib.pylib()
vmp_gui0.name='vmp_gui0'
vmp_gui0.dependencies=[]
vmp_gui0.pkg=True
pylib.pylibs_[vmp_gui0.name]=vmp_gui0

vmp_openssl0=pylib.pylib()
vmp_openssl0.name='vmp_openssl0'
vmp_openssl0.dependencies=['vmp','vmp_net','vmp_event']
vmp_openssl0.pkg=True
vmp_openssl0.cbuild()
vmp_openssl0.setup.files=[('./',['openssl_','pkey_','x509_','sslui_'])]
vmp_openssl0.setup.dependencies=['pylib','openssl0']
pylib.pylibs_[vmp_openssl0.name]=vmp_openssl0

vmp_openssl1=pylib.pylib()
vmp_openssl1.name='vmp_openssl1'
vmp_openssl1.dependencies=['vmp','vmp_net']
vmp_openssl1.pkg=True
vmp_openssl1.cbuild()
vmp_openssl1.setup.files=[('./',['openssl_','hash_','pkey_','x509_','sslui_','ctx_'])]
vmp_openssl1.setup.dependencies=['pylib','openssl1']
pylib.pylibs_[vmp_openssl1.name]=vmp_openssl1

vmp_rawnet1=pylib.pylib()
vmp_rawnet1.name='vmp_rawnet1'
vmp_rawnet1.dependencies=['vmp','vmp_event']
vmp_rawnet1.pkg=True
vmp_rawnet1.cbuild()
vmp_rawnet1.setup.files=[('./',['rawnet_','rawui_'])]
vmp_rawnet1.setup.dependencies=['pylib','rawnet1']
pylib.pylibs_[vmp_rawnet1.name]=vmp_rawnet1



