/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 20/05/2022
 */
 
#include "openssl_.h"

struct PySslClient_stub_Constructor:public pylib::Constructor<openssl::pkg::SslClient>
{
    openssl::pkg::SslClient *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            openssl::pkg::Ctx *ctx=args.get<openssl::pkg::Ctx *>(0);      
            return new openssl::pkg::SslClient(ctx);
        }
        return 0;
    }
};

struct PySslListen_stub_Constructor:public pylib::Constructor<openssl::pkg::SslListen>
{
    openssl::pkg::SslListen *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            openssl::pkg::Ctx *ctx=args.get<openssl::pkg::Ctx *>(0);      
            return new openssl::pkg::SslListen(ctx);
        }
        return 0;
    }
};

VAMPIRIA_PYLIB_INIT(vmp_openssl1_);

void openssl_init(pylib::Module module)
{
    //openssl0/openssl0.h
    
    module.def_("init",openssl::pkg::init);
    module.def_("end",openssl::pkg::end);

    //Context ssl. Processed in C ++ only
    module.class_no_constructor<openssl::pkg::Ctx>("Ctx");
    
    //SslClient
    pylib::Class<openssl::pkg::SslClient> sslclient=module.class_with_constructor<openssl::pkg::SslClient>("SslClient",PySslClient_stub_Constructor());
    sslclient.def_("reset",&openssl::pkg::SslClient::reset);
    sslclient.def_("socket",&openssl::pkg::SslClient::socket);
    sslclient.def_("block",&openssl::pkg::SslClient::block);
    sslclient.def_("noblock",&openssl::pkg::SslClient::noblock);
    sslclient.def_("type",&openssl::pkg::SslClient::type);
    sslclient.def_("get_local_address",&openssl::pkg::SslClient::get_local_address);
    sslclient.def_("get_peer_address",&openssl::pkg::SslClient::get_peer_address);
    sslclient.def_("sendData",&openssl::pkg::SslClient::sendData);
    sslclient.def_("recvData",&openssl::pkg::SslClient::recvData);
    sslclient.def_("key_update",&openssl::pkg::SslClient::key_update);
    sslclient.def_("get_peer_cerificate",&openssl::pkg::SslClient::get_peer_cerificate);
    sslclient.def_("close",&openssl::pkg::SslClient::close);
    sslclient.def_("connect",&openssl::pkg::SslClient::connect);
    sslclient.def_("connect_check",&openssl::pkg::SslClient::connect_check);
    sslclient.def_("ssl_connect",&openssl::pkg::SslClient::ssl_connect);
    
     //SslServer
    pylib::Class<openssl::pkg::SslServer> sslserver=module.class_no_constructor<openssl::pkg::SslServer>("SslServer");
    sslserver.def_("reset",&openssl::pkg::SslServer::reset);
    sslserver.def_("socket",&openssl::pkg::SslServer::socket);
    sslserver.def_("block",&openssl::pkg::SslServer::block);
    sslserver.def_("noblock",&openssl::pkg::SslServer::noblock);
    sslserver.def_("type",&openssl::pkg::SslServer::type);
    sslserver.def_("get_local_address",&openssl::pkg::SslServer::get_local_address);
    sslserver.def_("get_peer_address",&openssl::pkg::SslServer::get_peer_address);
    sslserver.def_("sendData",&openssl::pkg::SslServer::sendData);
    sslserver.def_("recvData",&openssl::pkg::SslServer::recvData);
    sslserver.def_("key_update",&openssl::pkg::SslServer::key_update);
    sslserver.def_("get_peer_cerificate",&openssl::pkg::SslServer::get_peer_cerificate);
    sslserver.def_("close",&openssl::pkg::SslServer::close);
    sslserver.def_("ssl_accept",&openssl::pkg::SslServer::ssl_accept);
    
    //Free Ssl server connection
    module.def_("sslserver_free_connection",openssl::pkg::sslserver_free_connection);
    
     //SslListen
    pylib::Class<openssl::pkg::SslListen> ssllisten=module.class_with_constructor<openssl::pkg::SslListen>("SslListen",PySslListen_stub_Constructor());
    ssllisten.def_("reset",&openssl::pkg::SslListen::reset);
    ssllisten.def_("socket",&openssl::pkg::SslListen::socket);
    ssllisten.def_("block",&openssl::pkg::SslListen::block);
    ssllisten.def_("noblock",&openssl::pkg::SslListen::noblock);
    ssllisten.def_("type",&openssl::pkg::SslListen::type);
    ssllisten.def_("get_local_address",&openssl::pkg::SslListen::get_local_address);
    ssllisten.def_("close",&openssl::pkg::SslListen::close);
    ssllisten.def_("server",&openssl::pkg::SslListen::server);
    ssllisten.def_("accept",&openssl::pkg::SslListen::accept,false);
    
}

void vampiria_pylib_init_module(pylib::Module init_module)
{
    openssl_init(init_module);
    openssl_hash(init_module);    
    openssl_pkey(init_module);
    openssl_x509(init_module);
    openssl_sslui(init_module);
    openssl_ctx(init_module);
}

 
 
