/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 28/09/2020
 */
 
#include "pylib.h"
#include "openssl0/openssl0.h"

#ifndef VAMPIRIA_PY_OPENSSL_H

#define VAMPIRIA_PY_OPENSSL_H 1

//!Python wrapper of the c++ namespace vampiria::openssl::pkg in vmp_openssl{version}.(see c++ doc)
/*!
    Function c++ in openssl{version}/openssl{version}.h(pkg):<BR>init(),end(),ctx_tls_generic(),ctx_tls_client(),ctx_tls_server(),
                                                                 ctx_pem_pkey_file(),ctx_pem_x509_file(),ctx_free()
*/
/*!
    Context class in openssl{version}/openssl{version}.h(pkg):<BR>No Constructor<BR>
*/
/*!
    SslClient class in openssl{version}/openssl{version}.h(pkg):<BR>Constructor SslClient(Ctx)<BR>
    SslClient member function list:<BR>reset(),socket(),block(),noblock(),type(),get_local_address(),get_peer_address(),
                                       sendData(),recvData(),key_update(),get_peer_cerificate(),shutdown(),close(),
                                       connect(),connect_check(),ssl_connect()
*/
/*!
    SslServer class in openssl{version}/openssl{version}.h(pkg):<BR>no constructor<BR>
    SslServer member function list:<BR>reset(),socket(),block(),noblock(),type(),get_local_address(),get_peer_address(),
                                       sendData(),recvData(),key_update(),get_peer_cerificate(),shutdown(),close(),
                                       ssl_accept()
*/
/*!
    SslListen class in openssl{version}/openssl{version}.h(pkg):<BR>Constructor SslListen(Ctx)<BR>
    SslListen member function list:<BR>reset(),socket(),block(),noblock(),type(),get_local_address(),close(),
                                                              server(),accept()
*/
void openssl_init(pylib::Module module);

//!Python wrapper of the c++ class vampiria::openssl::pkg::PKey in vmp_openssl{version}.PKey(see c++ doc)
/*!
    PKey class in openssl{version}/pkey.h(pkg):<BR>Constructor PKey()<BR>
    PKey member function list:<BR>reset(),key_print(),type_str()
*/
void openssl_pkey(pylib::Module module);

//!Python wrapper of the c++ class vampiria::openssl::pkg::X509_Wrap in vmp_openssl{version}.X509_Wrap(see c++ doc)
/*!
    X509_Wrap class in openssl{version}/x509.h.h(pkg):<BR>Constructor X509_Wrap()<BR>
    X509_Wrap member function list:<BR>reset(),parent(),version(),serial(),signature_info(),issuer(),validity_before(),
                                       validity_after(),subject(),pubkey(),id_issuer(),id_subject(),extensions(),
                                       signature_data(),fingerprint_sha1(),fingerprint_sha256()
*/
void openssl_x509(pylib::Module module);

//!Python wrapper of the c++ class vampiria::openssl::pkg::SslUI in vmp_openssl{version}.SslUI(see c++ doc)
/*!
    Wrapper Cell->ui() for ssl in sslui(cell)<BR>
    @return user interface ssl ui for cell.(The cell must be built with the SslUI user interface)
*/
/*!
    SslUI class in openssl{version}/sslui.h.h(pkg):<BR>Constructor SslUI(manager)<BR>
    SslUI member function list:<BR>set_event_client(),set_event_server(),new_client(),new_server(),send(),localaddr(),peeraddr(),
                                                        shutdown(),ssl()
    
*/
void openssl_sslui(pylib::Module module);

#endif

