#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 04/04/2020

import vmp

try:
  import tkinter as tk
  from vmp_gui0 import widget as widget
  from vmp_gui0 import popup  as popup
except Exception as e:
  vmp.external_module_error("tkinter")

##menudata cmd(Item in the Menu list)<BR>
#
#@param label label menu command<BR>
#@param callback command
def menu_cmd(label,cmd):
  return ('cmd',label,cmd)  

##menudata separator(Item in the Menu list)<BR>
def menu_separator():
  return ('separator',)

##menudata submenu(Item in the Menu list)<BR>
#
#@param submenu (see class Menu)
def menu_sub(submenu):
  return('submenu',submenu)

##Represents a menu in the menu bar
class Menu:
  ##A constructor<BR>
  #
  #@param label menu label<BR>
  #@param menudata list of menudata
  def __init__(self,label,menudata):
    self.label=label
    self.menudata=menudata
 
##Create Frame     
class Frame(tk.Frame):
  ##A constructor<BR>
  #
  #@param top true is top Frame<BR>
  #@param bg frame background<BR>
  #@param title frame title<BR>
  #@param width frame width<BR>
  #@param heigth frame height<BR>
  #@param posx frame position x<BR>
  #@param posy frame position y<BR>
  #@param resize frame resize?<BR>
  #@param padx frame padding x<BR>
  #@param pady frame padding y<BR>
  #@param ipadx widget internal padding x<BR>
  #@param ipady widget internal padding y<BR>
  #@param exit exit callback
  def __init__(self,top=False,bg=None,title=None,width=None,height=None,posx=0,posy=0,resize=True,padx=0,pady=0,ipadx=0,ipady=0,exit=None):
    tk.Frame.__init__(self,None)
    
    self.is_top=top
    self.is_active=False
    
    if self.is_top:
      self.top=tk.Toplevel(self.winfo_toplevel())
      self.winfo_toplevel().state(newstate='withdrawn')
    else:    
      self.top=tk.Toplevel(self)
      self.top.state(newstate='withdrawn')
      
    self.ref=self.top

    self.bg=bg
    if self.bg is not None:
      self.configure(bg=self.bg)
      self.top.configure(bg=self.bg)
      
    if title is not None:
      self.top.title(title)
    
    if (width is not None) and (height is not None):
      self.top.geometry("{0}x{1}+{2}+{3}".format(width,height,posx,posy))
    else:    
      self.top.geometry("+{0}+{1}".format(posx,posy))

    self.top.resizable(width=resize,height=resize)
    self.grid(padx=padx,pady=pady)

    self.ipadx=ipadx
    self.ipady=ipady

    if exit is None:
       self.top.protocol("WM_DELETE_WINDOW",self.close)    
    else:
       self.top.protocol("WM_DELETE_WINDOW",exit)    
  
    self.menubar=None
   
  ##Set frame menubar<BR>
  #
  #@param menulist menù list (see class Menu)
  def set_menu(self,menulist):
    if self.menubar == None:
       self.menubar=tk.Menu(self.top)
       self.top['menu']=self.menubar
       for value in menulist:
         self.add_submenu(self.menubar,value.label,value.menudata)
  
  ##Used by function set_menu         
  def add_submenu(self,menu,label,menudata):
    submenu=tk.Menu(menu)
    for data in menudata:
      if data[0] == 'cmd':
        submenu.add_command(label=data[1],command=data[2])
      elif data[0] == 'separator':
        submenu.add_separator()
      elif data[0] == 'submenu':
        self.add_submenu(submenu,data[1].label,data[1].menudata)
    menu.add_cascade(label=label,menu=submenu)
    
  ##Hide Frame
  def hide(self):
    self.top.state(newstate='withdrawn')

  ##Show Frame
  def show(self):
    self.top.state(newstate='normal')
  
  ##Active frame
  def active(self):
    if not self.is_active:
      if self.is_top:
         self.mainloop()
      else:
         self.show()  
      self.is_active=True
 
  ##default callback close frame
  def close(self):
    self.destroy()

  ##Set frame vertical scrollbar<BR>
  #
  #@param canvasbd canvas border pixel
  #@param canvashick the width of the highlight border scrollbar
  #@param scrollmax max height scrollmax
  def set_scrollbar(self,canvasbd=0,canvashick=0,scrollmax=500):
    vscrollbar = tk.Scrollbar(self.ref,orient=tk.VERTICAL)
    vscrollbar.pack(fill=tk.Y,side=tk.RIGHT,expand=tk.FALSE)
    canvas=tk.Canvas(self.ref,bg=self.bg,bd=canvasbd,highlightthickness=canvashick,yscrollcommand=vscrollbar.set)
    vscrollbar['command']=canvas.yview
    canvas.xview_moveto(0)
    canvas.yview_moveto(0)    
    canvas.pack()
    if self.bg is not None:
      self.ref=interior=tk.Frame(canvas,bg=self.bg)
    else:
      self.ref=interior=tk.Frame(canvas)

    interior_id = canvas.create_window(0,0,window=interior,anchor=tk.NW)

    def _configure_interior(event):
      size=(interior.winfo_reqwidth(),interior.winfo_reqheight())
      canvas.config(scrollregion="0 0 %s %s" % size)
      if interior.winfo_reqheight() > scrollmax:
        canvas.config(height=scrollmax)
      else:
        canvas.config(height=interior.winfo_reqheight())                 
      if interior.winfo_reqwidth() != canvas.winfo_width():
        canvas.config(width=interior.winfo_reqwidth())
    interior.bind('<Configure>', _configure_interior)
   
    def _configure_canvas(event):
      if interior.winfo_reqwidth() != canvas.winfo_width():
        canvas.itemconfigure(interior_id, width=canvas.winfo_width())
    canvas.bind('<Configure>', _configure_canvas)
  
  ##Add widget alignement nord
  #
  #@param spam column span
  def add_widget_n(self,widget,row,column,rspan=1,cspan=1):
    widget.get_widget().grid(row=row,column=column,rowspan=rspan,columnspan=cspan,padx=self.ipadx,pady=self.ipady,sticky=tk.N)
    
  ##Add widget alignement nord-west
  #
  #@param widget widget to insert
  #@param row row index
  #@param rspan row span
  #@param column column index
  #@param cspan column span
  def add_widget_nw(self,widget,row,column,rspan=1,cspan=1):
    widget.get_widget().grid(row=row,column=column,rowspan=rspan,columnspan=cspan,padx=self.ipadx,pady=self.ipady,sticky=tk.W+tk.N)
   
  ##Add widget alignement nord-east
  #
  #@param widget widget to insert
  #@param row row index
  #@param rspan row span
  #@param column column index
  #@param cspan column span
  def add_widget_ne(self,widget,row,column,rspan=1,cspan=1):
    widget.get_widget().grid(row=row,column=column,rowspan=rspan,columnspan=cspan,padx=self.ipadx,pady=self.ipady,sticky=tk.E+tk.N)
    
  ##Add widget alignement center
  #
  #@param widget widget to insert
  #@param row row index
  #@param rspan row span
  #@param column column index
  #@param cspan column span
  def add_widget_c(self,widget,row,column,rspan=1,cspan=1):
    widget.get_widget().grid(row=row,column=column,rowspan=rspan,columnspan=cspan,padx=self.ipadx,pady=self.ipady)
   
  ##Add widget alignement west
  #
  #@param widget widget to insert
  #@param row row index
  #@param rspan row span
  #@param column column index
  #@param cspan column span
  def add_widget_w(self,widget,row,column,rspan=1,cspan=1):
    widget.get_widget().grid(row=row,column=column,rowspan=rspan,columnspan=cspan,padx=self.ipadx,pady=self.ipady,sticky=tk.W)
    
  ##Add widget alignement east
  #
  #@param widget widget to insert
  #@param row row index
  #@param rspan row span
  #@param column column index
  #@param cspan column span
  def add_widget_e(self,widget,row,column,rspan=1,cspan=1):
    widget.get_widget().grid(row=row,column=column,rowspan=rspan,columnspan=cspan,padx=self.ipadx,pady=self.ipady,sticky=tk.E)
    
  ##Add widget alignement south
  #
  #@param widget widget to insert
  #@param row row index
  #@param rspan row span
  #@param column column index
  #@param cspan column span
  def add_widget_s(self,widget,row,column,rspan=1,cspan=1):
    widget.get_widget().grid(row=row,column=column,rowspan=rspan,columnspan=cspan,padx=self.ipadx,pady=self.ipady,sticky=tk.S)
    
  ##Add widget alignement south-west
  #@param widget widget to insert
  #@param row row index
  #@param rspan row span
  #@param column column index
  #@param cspan column span
  def add_widget_sw(self,widget,row,column,rspan=1,cspan=1):
    widget.get_widget().grid(row=row,column=column,rowspan=rspan,columnspan=cspan,padx=self.ipadx,pady=self.ipady,sticky=tk.W+tk.S)
    
  ##Add widget alignement south-east
  #@param widget widget to insert
  #@param row row index
  #@param rspan row span
  #@param column column index
  #@param cspan column span
  def add_widget_se(self,widget,row,column,rspan=1,cspan=1):
    widget.get_widget().grid(row=row,column=column,rowspan=rspan,columnspan=cspan,padx=self.ipadx,pady=self.ipady,sticky=tk.E+tk.E)


