#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 18/03/2020

import vmp

##Software name
name_="gvampiria"

##Vampiria exe name
vname_="vampiria"

#path gvampiria
path_=vmp.env.software_path(name_)

##path dtd file
path_dtd_=vmp.env.software_path(name_,"gvampiria.dtd")

##xml project path
path_project_=vmp.env.software_path(name_,"xml/")

##home path vampiria 
path_home_=vmp.env.vampiria_home(name_)

##home path vampiria customized project
path_custom_="{0}/customized/".format(path_home_)

##home path vampiria static project
path_static_="{0}/static/".format(path_home_)

##home path vampiria static auto save project
path_auto_="{0}auto/".format(path_static_)

##directory home privilegies
dir_priv_=0o755

##Open customized project
lcmd_customized_open_="Open Customized gui"

##Open static project Command label
lcmd_static_open_="Open vampiria project"

##Exit Command label
lcmd_exit_="Quit"

##Info Command
cmd_info_="{0} -i".format(vmp.env.vampiria_bin(vname_))

##Info Command label
lcmd_info_="Info"

##Version Command
cmd_version_="{0} -v".format(vmp.env.vampiria_bin(vname_))

##Version Command label
lcmd_version_="Version"

##Path command
cmd_path_="{0} -p".format(vmp.env.vampiria_bin(vname_))

##Path command label
lcmd_path_="Path"

##Modules command label
lcmd_modules_="Modules list"

##Modules command
cmd_modules_="{0} -l;".format(vmp.env.vampiria_bin(vname_))

##Modules command label
lcmd_imodules_="Modules info"

##Modules label frame
l_imodules_="Digit Module name:"

##Modules command
def cmd_imodules_(modname):
  return "{0} -m {1}".format(vmp.env.vampiria_bin(vname_),modname)

##Exec check label
def lcmd_check_(fname):
  return "Vampiria Check {0}".format(fname)

##Vampiria check command
def cmd_check_(fname):
  return "{0} -c {1}".format(vmp.env.vampiria_bin(vname_),fname)

##Exec command label
#
#@param fname vampiria xml file
#@param debug debug mode?
#@return command label 
def lcmd_exec(fname,debug):
  if debug:
    return "Vampiria Run {0}(debug mode)".format(fname)
  return "Vampiria Run {0}".format(fname)

##Vampiria exec command
#
#@param fname vampiria xml file
#@param debug debug mode?
#@return command string
def cmd_exec_(fname,debug):
  if debug:
    return "{0} -d {1}".format(vmp.env.vampiria_bin(vname_),fname)
  return "{0} -r {1}".format(vmp.env.vampiria_bin(vname_),fname)

##Label check error
lcheck_error_="Check error"

##Label run error
lrun_error_="Run error"

##Label save file error
lsave_error_="Save error"

##Save error command question
def lsave_question_error_(fname):
  return "The {0} file cannot be saved. Do you want to continue with the original file?".format(fname)

##Gui generic:title ask input error
common_inputerr_='Input Error'

##Gui Frame config: Background frame color
frame_bg_="#a7a3a3"

##Gui Frame config: Frame windows title
frame_title_="Vampiria Gui - "

##Gui frame fatal error
frame_fatal_error_="{0}Fatal error".format(frame_title_)

##Gui generic:frame padding x
frame_padx_=10                                   

##Gui generic:frame padding y
frame_pady_=10	                           

##Gui generic:frame internal padding x
frame_ipadx_=5		                   

##Gui generic:frame internal padding y
frame_ipady_=5

##Gui generic:frame entry size
frame_entry_size_=15

##Gui generic:frame default button run
frame_button_run_="run"

##Gui generic: confirm message
#frame_confrm_msg_="Are You Sure?"

##Gui ask question confirm delete file message
#
#@param fname file name
#@return string message
def frame_confrm_delete_msg_(fname):
  return "Are you sure you want to cancel the {0} file?".format(fname)

##Gui show error title delete file
#
#@param fname file name
#@return string message
def frame_delete_error_title_(fname):
  return "Delete {0} files".format(fname)
 
##Gui Main Frame config:main frame subtitle
main_subtitle_="Main"

##Gui Main Frame config: width frame
main_width_=400

##Gui Main Frame config: width frame
main_height_=580  

##Gui Main Frame config: position x frame
main_posx_=300

##Gui Main Frame config: position y frame
main_posy_=50

##Gui Main Frame config: is resize?
main_resize_=False

##Gui Main Frame config:file menu label
main_filemenu_="File"

##Gui Main Frame config:help menu label
main_helpmenu_="Vampiria"

##Gui Main Frame config:label root yes
main_root_="User Root"			       

##Gui Main Frame config:label root no
main_noroot_="User No Root"

##Gui Main Frame config:label project group  gui
main_lgroup_project_="Select group project:"

##Gui Main Frame config:label project gui
main_label_project_="Select gui:"

##Gui Main Frame config:witdh list box in main
main_wbox_=20                            	       

##Gui Main Frame config:height list box in main
main_hbox_=11

##Gui Main Frame config:button label open group gui 
main_lbutton_gopen_="Open gui group"

##Gui Main Frame config:button label run gui
main_lbutton_grun_ ="Run gui"

##Gui modules Frame config:error title mbox
main_ggui_error_title_="Group gui error"

##Gui modules Frame config:error message select modules group
main_ggui_error_="Please,select group gui!"

##Gui Main Frame config:select gui title error
main_gui_error_title_="Gui error"           

##Gui Main Frame config:select gui message error
main_gui_error_msg_="Please,select gui!"

##Gui Mask frame config:frame mask subtitle
mask_subtitle_='Run Project '

##Gui Mask frame config:frame mask internal padding x
mask_ipadx_=5					            

##Gui Mask frame config:frame mask internal padding y
mask_ipady_=15

##Gui Mask frame config:gui mask title error
mask_error_title_="Gui error"

##Gui Mask frame config:description line size in mask
mask_desc_size_=60

##Gui Mask frame config:label path run location
mask_titlepath_='Run location:'

##Gui Mask frame config:checkbutton debug label
mask_debug_='Debug'			   	            

##Gui Mask frame config:change run file label button and title ask
mask_cbutton_="Change run location"			    

##Gui Mask frame config:label button save
mask_sbutton_=' Save  '	                            

##Gui Mask frame config:label button run
mask_rbutton_='  Run  '	

##Gui Mask frame config:sleep wait enable button in mask
mask_sleep_run_=1

##Gui Mask frame config:label line size in mask
mask_label_size_=15

##Gui Mask frame config:label width in grid
mask_label_width_=1	

##Gui Mask frame config:mask grid width
mask_grid_width_=4

##Gui Mask frame config:widget width in grid
mask_widget_width_=2				    

##Gui Mask frame config:var width in grid
mask_var_width_=1

##Gui Static frame config:frame static subtitle
static_subtitle_='Vampiria Project'

##Gui Static frame config:frame mask internal padding x
static_ipadx_=5					            

##Gui Static frame config:frame mask internal padding y
static_ipady_=15

##Gui Static frame config:label path run location
static_titlepath_='Project: '

##Gui Static frame config:mask grid width
static_grid_width_=4

##Gui Static frame config:width editor
static_editor_width_=60			   

##Gui Static frame config:height editor
static_editor_height_=20

##Gui Static frame config:Open button file label
static_bopen_="Open"

##Gui Static frame config:Delete button file label
static_bdelete_="Delete"

##Gui Static frame config:Save button file label
static_bsave_="Save"

##Gui Static frame config:Save as name button file label
static_bsaveas_="Save as name"

#Gui Static frame config:Replace button file label
static_breplace_="Replace Xml Doc"

#Gui Static frame config:Check button file label
static_bcheck_="Check"

#Gui Static frame config:Debug Checkbutton file label
static_bdebug_="Debug"

#Gui Static frame config:Run button file label
static_brun_="Run"

##Gui Static frame config:frame ask title select static project
static_run_ask_="Select vampiria project"

##Gui Static frame config:frame ask title save static project
static_save_ask_='Save vampiria project'

##Gui Custom frame config:frame static subtitle
custom_subtitle_='Customized Project'

##Gui Custom frame config:frame mask internal padding x
custom_ipadx_=5					            

##Gui Custom frame config:frame mask internal padding y
custom_ipady_=15

##Gui Custom frame config:label path run location
custom_titlepath_='Customized Project: '

##Gui Custom frame config:mask grid width
custom_grid_width_=5

##Gui Custom frame config:width editor
custom_editor_width_=60			   

##Gui Custom frame config:height editor
custom_editor_height_=20

##Gui Custom frame config:Open button file label
custom_bopen_="Open"

##Gui Custom frame config:Delete button file label
custom_bdelete_="Delete"

##Gui Custom frame config:Save button file label
custom_bsave_="Save"

##Gui Custom frame config:Save as name button file label
custom_bsaveas_="Save as name"

#Gui Custom frame config:Replace button file label
custom_breplace_="Replace Xml Doc"

#Gui Custom frame config:Run button file label
custom_brun_="Run Gui"

##Gui Custom frame config:frame ask title select static project
custom_run_ask_="Select customized project"

##Gui Custom frame config:frame ask title save static project
custom_save_ask_='Save customized project'

##Title show error customized replace header error
custom_replace_error_="Customized replace error"

##Customized file title
def custom_project_title_(fname):
  return "Customized_{0}_files".format(fname)

##widget entry min size value
widget_entry_minsize_=1

##widget entry max size value
widget_entry_maxsize_=30

##widget entry background
widget_entry_bg_="#FFFFFF"

##Gui Mask frame config:default mindata entry
widget_entry_mindata_=0			            

##Gui Mask frame config:default maxdata entry
widget_entry_maxdata_=4096

##Gui Mask frame config:list entry height
widget_listentry_height_=3

