/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 10/08/2021
 */

#include "rawnet1/rawnet1.h"

namespace vampiria { namespace rawnet { namespace pkg {

EventRawNet::EventRawNet():event::EventThread()
{
    rawnet_=0;
    evt_rawnet_reset();    
}

EventRawNet::~EventRawNet()
{
    evt_rawnet_reset();
}

void EventRawNet::evt_rawnet_reset()
{
    rawnet::pkg::close_rawnet(&rawnet_);
    ifname_="";
    filter_="";
    isread_=true;
    recv_=0;
    linktype_=-1;
    linktype_str_="";
}

vmp::str EventRawNet::evt_rawnet_iface()
{
    return ifname_;
}
        
vmp::str EventRawNet::evt_rawnet_filter()
{
    if(!isread_)
       vmp::except_s("rawnet::pkg::EventRawNet not filter in writeonly mode");
    return filter_;
}

vmp::str EventRawNet::evt_rawnet_mode()
{
    if(isread_)
        return "readwrite";
    return "writeonly";
}

vmp_int EventRawNet::evt_rawnet_linktype()
{
    return linktype_;
}
        
vmp::str EventRawNet::evt_rawnet_linktype_str()
{
    return linktype_str_;
}

void rawnet_read_ev(vmp::Buf *buf,void *arg)
{
    event::Cell *cell=(event::Cell *)arg;
    event::Manager *manager=cell->get_manager();
    rawnet::pkg::EventRawNet *event=cell->event<rawnet::pkg::EventRawNet>();
    manager->lock();
    vmp_bool exec=manager->cell_update(cell);
    manager->unlock();
    if(exec)
        event->recv_(cell,buf);  
}

void rawnet_read_run(event::Cell *cell)
{
    rawnet::pkg::EventRawNet *event=cell->event<rawnet::pkg::EventRawNet>();
    rawnet::pkg::loop_rawnet(event->rawnet_,rawnet::pkg::rawnet_read_ev,(void *)cell);
}

event::Cell *EventRawNet::evt_rawnet_rw_new(event::UI *ui,vmp::str ifname,vmp::str filter,net::EVTCBRECV recv,event::EVTCB close)
{
    rawnet::pkg::rawnet_t handle=rawnet::pkg::open_live(ifname);
    try
    {
        rawnet::pkg::filter_rawnet(handle,filter);
        rawnet_=handle;
        ifname_=ifname;
        filter_=filter;
        recv_=recv;
        isread_=true;
        linktype_=rawnet::pkg::datalink_rawnet(rawnet_);
        linktype_str_=rawnet::pkg::linktype_str(linktype_);
    }
    catch(vmp::exception &x)
    {
        rawnet::pkg::close_rawnet(&handle);
        evt_rawnet_reset();
        vmp::except_s(x.what());
    }
    return evt_thread_new(ui,rawnet::pkg::rawnet_read_run,0,close);    
}

event::Cell *EventRawNet::evt_rawnet_w_new(event::UI *ui,vmp::str ifname,event::EVTCB close)
{
    rawnet::pkg::rawnet_t handle=rawnet::pkg::open_live(ifname);
    try
    {
        rawnet_=handle;
        ifname_=ifname;
        filter_="";
        recv_=0;
        isread_=false;
        linktype_=rawnet::pkg::datalink_rawnet(rawnet_);
        linktype_str_=rawnet::pkg::linktype_str(linktype_);
    }
    catch(vmp::exception &x)
    {
        rawnet::pkg::close_rawnet(&handle);
        evt_rawnet_reset();
        vmp::except_s(x.what());
    }
    return evt_new(ui,-1,0,close);
}

void EventRawNet::evt_rawnet_loop()
{
    if(isread_)
        evt_thread_start();
}

void EventRawNet::evt_rawnet_inject(vmp::Buf *buf)
{
    event::Manager *manager=cell_->get_manager();
    if(manager->cell_update(cell_))
        rawnet::pkg::inject_rawnet(rawnet_,buf);
}

void EventRawNet::evt_rawnet_close()
{
    if(isread_)
        evt_thread_close();
    else
        evt_close();
    
}

void EventRawNet::evt_rawnet_free()
{
    if(isread_)
        evt_thread_free();
    else
        evt_free();
    evt_rawnet_reset();
}

}}}

