/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 20/05/2022
 */

#include "openssl1/openssl1.h"

namespace vampiria { namespace openssl { namespace pkg {

vmp::str md5(vmp::str istr,vmp::str delimiter)
{
    vmp::Buf buf;
    buf.newsize(MD5_DIGEST_LENGTH);
    MD5_CTX md5;
    MD5_Init(&md5);
    MD5_Update(&md5,istr.c_str(),istr.size());
    MD5_Final(buf.pointer(),&md5);
    return buf.read_xstr_hm(buf.size(),delimiter);
}

vmp::str sha1(vmp::str istr,vmp::str delimiter)
{
    vmp::Buf buf;
    buf.newsize(SHA_DIGEST_LENGTH); 
    SHA_CTX sha1;
    SHA1_Init(&sha1);
    SHA1_Update(&sha1,istr.c_str(),istr.size());
    SHA1_Final(buf.pointer(),&sha1);
    return buf.read_xstr_hm(buf.size(),delimiter);
}

vmp::str sha224(vmp::str istr,vmp::str delimiter)
{
    vmp::Buf buf;
    buf.newsize(SHA224_DIGEST_LENGTH); 
    SHA256_CTX sha224;
    SHA224_Init(&sha224);
    SHA224_Update(&sha224,istr.c_str(),istr.size());
    SHA224_Final(buf.pointer(),&sha224);
    return buf.read_xstr_hm(buf.size(),delimiter);
}
   
vmp::str sha256(vmp::str istr,vmp::str delimiter)
{
    vmp::Buf buf;
    buf.newsize(SHA256_DIGEST_LENGTH); 
    SHA256_CTX sha256;
    SHA256_Init(&sha256);
    SHA256_Update(&sha256,istr.c_str(),istr.size());
    SHA256_Final(buf.pointer(),&sha256);
    return buf.read_xstr_hm(buf.size(),delimiter);
}

vmp::str sha384(vmp::str istr,vmp::str delimiter)
{
    vmp::Buf buf;
    buf.newsize(SHA384_DIGEST_LENGTH); 
    SHA512_CTX sha384;
    SHA384_Init(&sha384);
    SHA384_Update(&sha384,istr.c_str(),istr.size());
    SHA384_Final(buf.pointer(),&sha384);
    return buf.read_xstr_hm(buf.size(),delimiter);
}

vmp::str sha512(vmp::str istr,vmp::str delimiter)
{
    vmp::Buf buf;
    buf.newsize(SHA512_DIGEST_LENGTH); 
    SHA512_CTX sha512;
    SHA512_Init(&sha512);
    SHA512_Update(&sha512,istr.c_str(),istr.size());
    SHA512_Final(buf.pointer(),&sha512);
    return buf.read_xstr_hm(buf.size(),delimiter);
}

}}}

