/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 07/01/2020
 */

#include <time.h>
#include <sys/time.h>

#ifndef VAMPIRIA_VMP_TIME_H

#define VAMPIRIA_VMP_TIME_H 1

namespace vampiria { namespace vmp { namespace time {

//!time base type(s.ms)
typedef vmp_real Time;

//! timeval type
typedef struct timeval *Timeval;

//! Alloc Timeval
/*!
    @return timeval struct
*/
vmp::time::Timeval timeval_new();

//!Convert the timeval format Time
/*!
    @param tval input timeval time
    \return time 
*/
vmp::time::Time timeval_to_time(vmp::time::Timeval tval);

//!Convert the Time format timeval(new dynamic timeval struct is allocated)
/*!
     @param time input time
     @return timeval converterd
*/
vmp::time::Timeval time_to_timeval(vmp::time::Time time);

//! Free Timeval struct and settin (*pval) = 0
/*!
    @param ptval pointer to timeval
*/
void timeval_free(vmp::time::Timeval *ptval);

//!Causes the calling thread to sleep for time
/*!
    @param time time to sleep thread
*/
void vsleep(vmp::time::Time time);

//!Returns the time as the number of seconds since the Epoch,1970-01-01 00:00:00 +0000 (UTC).
/*!
    return time,except error
*/
vmp_uint time_wrap();

//!Returns the current time in string format
/*!
    @return current time string
*/
vmp::str ctime_wrap();

//!Timer object utility
class Timer
{
    private:
        struct timeval tinit_;/*!< Init time*/    
    public:    
        //! A constructor        
        Timer();

        //! A destructor
        ~Timer();
        
        //!Set the initial time reference to the current time
        /*!
            @sa tinit_
        */
        void init();
        
        //! Returns the current time than the time init
        /*!
            @sa tinit_             
            @return current time
        */
        vmp::time::Time now();
};

}}}

#endif

