/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 07/01/2020
 */

#include "vmp.h"

time_t vmp_time()
{
    return time(0);
}

namespace vampiria { namespace vmp { namespace time {

vmp::time::Timeval timeval_new()
{
    vmp::time::Timeval ret=(vmp::time::Timeval) vmp::malloc_wrap(sizeof(struct timeval));
    ret->tv_sec=0;
    ret->tv_usec=0;
    return ret;
}

vmp::time::Time timeval_to_time(vmp::time::Timeval tval)
{
    vmp::time::Time s=(vmp::time::Time)(tval->tv_sec);
    vmp::time::Time us=((vmp::time::Time)(tval->tv_usec))/1000000;     
    return s+us;
}

vmp::time::Timeval time_to_timeval(vmp::time::Time time)
{
    vmp::time::Timeval ret=0;
    if(time > 0.0)
    {
       ret=timeval_new();
       ret->tv_sec=(time_t) time;
       ret->tv_usec=(suseconds_t) ((time-(time_t)ret->tv_sec) * 1000000);
    }
    return ret;
}

void timeval_free(vmp::time::Timeval *ptval)
{
    vmp::free_wrap((void **)ptval);
}

void vsleep(vmp::time::Time time)
{
    if(time > 0.0)
    {
        vmp_uint sec,msec;
        sec=(vmp_uint) time;
        msec=(vmp_uint)((time - ((vmp::time::Time) sec)) * 1000000);
        sleep_wrap(sec);
        usleep_wrap(msec); 
    }
    
}

vmp_uint time_wrap()
{
    time_t t=vmp_time();
    if(t == -1)
        vmp::except_errno();
    return (vmp_uint) t; 
}

vmp::str ctime_wrap()
{
    time_t t=vmp_time();
    vmp::str ret=ctime(&t);
    return ret.substr(0,ret.size()-1);
}

Timer::Timer()
{
    init();    
}

Timer::~Timer()
{
}

void Timer::init()
{
    gettimeofday(&tinit_,0);    
}
        
vmp::time::Time Timer::now()
{
    struct timeval now;
    gettimeofday(&now,0);  
    vmp::time::Time s=(vmp::time::Time)(now.tv_sec -tinit_.tv_sec);
    vmp::time::Time us=(((vmp::time::Time)(now.tv_usec))-((vmp::time::Time)(tinit_.tv_usec)))/1000000; 
    return s+us; 
    
}

}}}

