/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 08/11/2020
 */

#include "vmp.h"

namespace vampiria { namespace vmp { namespace math {

vmp_real pow_wrap(vmp_real x,vmp_real y)
{
     return pow(x,y);
}

vmp_uint16 checksum16(vmp::Buf *buf)
{
    vmp::except_check_pointer((void *) buf,"vmp::math::checksum16() null pointer input buf");
    if((buf->size() % 2) == 1)
        buf->newsize(buf->size()+1);
    vmp_size ret=0;
    buf->index();
    while(!buf->eob())
        ret += buf->read_size(2);
    while(ret > 0xFFFF)
        ret=(0xFFFF & ret) + (ret >> 16);
    ret = ~ret;
    return (vmp_uint) ret;
}

vmp::str checksum16_str(vmp::Buf *buf)
{
    vmp::str ret;
    vmp::unicode::str_write(&ret,"%04X",checksum16(buf));
    return ret;
}

}}}

