/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 22/11/2019
 */

#include <assert.h>
#include <errno.h>

#include <exception>
#include <stdexcept>

#ifndef VAMPIRIA_VMP_ERROR_H

#define VAMPIRIA_VMP_ERROR_H 1

namespace vampiria { 

#define vmp_assert(value) assert(value) /*!< abort the program if assertion is false */

namespace vmp {

//! wrapper exception c++ default
using exception=std::exception;

//! wrapper exception alloc
using bad_alloc=std::bad_alloc;

//! wrapper invalid arguments  
using invalid_argument=std::invalid_argument;

//! runtime error exception
using runtime_error=std::runtime_error;

//!generic exception struct
struct exception_default : exception 
{
    private:
       vmp::str error_;
    public:
       exception_default(vmp::str error){error_=error;}
       const vmp_char *what() const noexcept {return error_.c_str();}
};

//!throws exception default
/*!
     @param msg message error
*/
void except_s(vmp::str msg="");

//!throws exception default
/*!
    @param fmt format message error
    @param ... args list format string
*/
void except(const vmp_char *fmt,...);

//!throws invalid argument exception
/*!
     @param msg message error
*/
void except_args_s(vmp::str msg="");

//!throws exception default
/*!
    @param fmt format message error
    @param ... args list format string
*/
void except_args(const vmp_char *fmt,...);

//!throws alloc exception
void except_alloc();

//!throws errno exception
void except_errno();

//!throws errno exception. set errno manually
/*!
    @param err errno value
*/
void except_errno_set(vmp_int err);

//!throws runtime error exception.
/*!
    @param err runtime error
*/
void except_runtime(vmp::str err); 

//!Check if the input pointer is null.If it is, it throws an exception with error
/*!
     @param pointer pointer to check
     @param error exception string error
*/
void except_check_pointer(void *pointer,vmp::str error);

}}

extern vmp_int errno;

#endif

