/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 19/11/2019
 */

#ifndef VAMPIRIA_VMP_H

#define VAMPIRIA_VMP_H 1

namespace vampiria {

//! char
typedef char vmp_char;

//! unsigned char 
typedef unsigned char vmp_uchar; 

//! integer 32 bit
typedef int vmp_int;

//! unsigned integer 32 bit
typedef unsigned int vmp_uint;

//! integer 16 bit
typedef short int vmp_int16;

//!unisigned int 16 bit
typedef unsigned short int vmp_uint16;

//! real
typedef double vmp_real;

//! size (unsigned int 32 bit)
typedef unsigned int vmp_size;

//! index (unsigned int 32 bit)
typedef unsigned int vmp_index;

//! byte (unsigned char)
typedef unsigned char vmp_byte;

//! boolean(true or false)
typedef bool vmp_bool;

}

using namespace vampiria;

#endif

#include "vmp/basetypes.h"
#include "vmp/env.h"
#include "vmp/buf.h"
#include "vmp/signal.h"
#include "vmp/thread.h"
#include "vmp/io.h"
#include "vmp/error.h"
#include "vmp/time.h"
#include "vmp/lib.h"
#include "vmp/table.h"
#include "vmp/unicode.h"
#include "vmp/utils.h"
#include "vmp/args.h"
#include "vmp/math.h"


