/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 26/01/2020
 */

#ifndef VAMPIRIA_PYLIB_STUB_H

#define VAMPIRIA_PYLIB_STUB_H 1

namespace vampiria { namespace pylib {

//!Basic structure for creating stubs. Stubs contain code that executes the wrapper between C ++ python
struct Stub
{
    //! A constructor 
    Stub() {}
    
    //! A destructor
    virtual ~Stub(){}
    
    //! Virtual operator implemented in substruct. (Contains wrapper code)
    /*!
        @param iargs tuple python input arguments
        @param kw dictionary key input arguments
        @return return value of the function in python mode(except error)
    */
    virtual pylib::Objref *operator()(pylib::Objref *iargs,pylib::Objref *kw)=0;
};

//!Stub used for the basic functions wrapper
struct Generic_def:public pylib::Stub
{
    //!operator implemeted
    pylib::Objref *operator()(pylib::Objref *iargs,pylib::Objref *kw);
    
    //! Implemented in derived structures, wrapper code
    /*!
        @param args arguments input
        @param kwargs keyword arguments(not implemeted)
	@return return value of the function in python mode or 0 (invalid arguments number). (Exception : except error, error_args number)	
   */
    virtual pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)=0;
};

//!Stub used for the class Constructor
template<class Wrap>
struct Constructor:public pylib::Stub
{
     //!operator implemeted
    pylib::Objref *operator()(pylib::Objref *iargs,pylib::Objref *kw)
    {
        pylib::Args args(iargs,1);
        pylib::KwArgs kwargs(kw);
        Wrap *inst=build_instance(args,kwargs);
        if(inst == 0)
            return 0;
        pylib::set_instance(pylib::pytuple_getitem(iargs,0),inst);
        return pylib::retnone();
    }
    
    //! Implemented in derived structures, wrapper code
    /*!
        @param args arguments input
        @param kwargs keyword arguments(not implemeted)	
        @return c++ instance or 0 (invalid arguments number). (Exception : except error, error_args number)	
    */
    virtual Wrap *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)=0;
};

//!Stub used for the calss member functions wrapper
template<class Wrap>
struct Member_def:public pylib::Stub
{
    //!operator implemeted
    pylib::Objref *operator()(pylib::Objref *iargs,pylib::Objref *kw)
    {
         Wrap *inst;
         try
         {
             
             inst=(Wrap *)find_instance_impl(pylib::pytuple_getitem(iargs,0),pylib::type_id<Wrap>());
             if(inst==0)
                 vmp::except_s("");
         }
         catch(vmp::exception &x)
         {
             vmp::except_s("invalid instance type");
         }
         pylib::Args args(iargs,1);
         pylib::KwArgs kwargs(kw);
         return def(inst,args,kwargs);         
    }

     //! Implemented in derived structures, wrapper code
    /*!
        @param instance instance class
        @param args arguments input
        @param kwargs keyword arguments(not implemeted)
	@return return value of the function in python mode or 0 (invalid arguments number). (Exception : except error, error_args number)	
   */
    virtual pylib::Objref *def(Wrap *instance,pylib::Args &args,pylib::KwArgs &kwargs)=0; 
};

}}

#endif

#include "stub/signature.h"
#include "stub/stub_def.h"
#include "stub/stub_constructor.h"
#include "stub/stub_member.h"


