/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 17/11/2020
 */

#ifndef VAMPIRIA_PACKET_SIZE_H

#define VAMPIRIA_PACKET_SIZE_H 1

namespace vampiria { namespace packet {

//! DataType size
class DataSize:public packet::DataBytes
{
    protected:
        vmp_size data_;/*!< Size Data*/
        vmp_size datalen_;/*!<Number of bytes used by the data(values from 1 to 4)*/
    public:
	//! A constructor
        /*!
            @param field data field
            @param datalen data length value(values from 1 to 4)
        */
        DataSize(vmp::str field,vmp_size datalen);
        
        //! A destructor
        ~DataSize();

        //! Virtual function
        vmp::str get(vmp::str field);

        //! Virtual function
        void set(vmp::str field,vmp::str data);
        
	//! Virtual function    
        void read(vmp::Buf *buf);
        
	//! Virtual function
        void write(vmp::Buf *buf);

        //! Get data in raw mode
        /*!
            @return data
            @sa data_
        */
        vmp_size get_data();
	
	//! Set data in raw mode
        /*!
	     @param data data value
             @return void or except by mistake
        */
        void set_data(vmp_size data); 
};

//! DataType size(hexadecimal mode)
class DataHexSize:public packet::DataSize
{
    public:
	//! A constructor
        /*!
            @param field data field
            @param datalen data length value(values from 1 to 4)
        */
        DataHexSize(vmp::str field,vmp_size datalen);
        
         //! A destructor
        ~DataHexSize();

         //! Virtual function
        vmp::str get(vmp::str field);
    
         //! Virtual function
        void set(vmp::str field,vmp::str data);        
};

//!Selection data with numeric 
class DataSelect:public packet::DataSize
{
    private:
        vmp::Table<vmp_size,vmp::str *> code_;/*!<Internal usage*/
        vmp::Table<vmp::str,vmp_size *> strcode_;/*!<Internal usage*/
    public:
        //! A constructor
        /*!
            @param field data field
            @param datalen data length value(values from 1 to 4)
        */
        DataSelect(vmp::str field,vmp_size datalen);
        
        //! A destructor
        ~DataSelect();

         //! Virtual function
        vmp::str get(vmp::str field);
        
        //! Virtual function
	void set(vmp::str field,vmp::str data);

        //! Insert selectable data
        /*!
            @param name data name
            @param code data code(The maximum acceptable value of the code depends on the size set in the constructor)
            @return void or except to mistake
        */
        void insert_code(vmp::str strcode,vmp_size code);    
};

}}

#endif

