/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 23/10/2020
 */

#include "packet.h"

namespace vampiria { namespace packet {

DataBuffer::DataBuffer(vmp::str field,vmp_size setsize):packet::DataBytes(field)
{
    setsize_=setsize;
    buf_.newsize(setsize_);
}

DataBuffer::~DataBuffer()
{
    buf_.reset();
}

vmp::str DataBuffer::get(vmp::str field)
{
    buf_.index();
    return buf_.read_str(buf_.size());
}

void DataBuffer::set(vmp::str field,vmp::str data)
{
    buf_.reset();
    buf_.write_str(data);
    if(setsize_ != 0)
        buf_.newsize(setsize_);
}

void DataBuffer::read(vmp::Buf *buf)
{
    if(setsize_ == 0)
        buf->read_buf(&buf_,buf->size_reading());
    else
        buf->read_buf(&buf_,setsize_);
}
        
void DataBuffer::write(vmp::Buf *buf)
{
    buf->write_buf(&buf_);
}

vmp::str DataBuffer::print()
{
    vmp::str ret;
    vmp::vector<vmp::str> f=fields();
    buf_.index();
    vmp::unicode::str_write(&ret,"%s: %s",f[0].c_str(),buf_.read_xstr_hm(buf_.size()," ").c_str());
    return ret;
}

vmp::Buf *DataBuffer::DataBuffer::get_data()
{
    return &buf_;
}

void DataBuffer::read_size_data(vmp::Buf *buf,vmp_size size)
{
    buf->read_buf(&buf_,size);
    if(setsize_ != 0)
        buf_.newsize(setsize_);
}

}}

