/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 06/04/2022
*/

#include "json.h"

namespace vampiria { namespace json {

JList::JList()
{
    list_=0;
    jtype_="";
}
         
JList::~JList()
{
    reset();
}

void JList::check_init(vmp::str fname)
{
    if(list_ == 0)
        vmp::except("json::JList::%s() list json obj not setting",fname.c_str());
}

void JList::reset()
{
    if(list_ != 0)
        delete list_;
    list_=0;
    jtype_="";
}

void JList::set(json::JsonObj *list,vmp::str jtype)
{
    vmp::except_check_pointer((void *) list,"json::JList::set() null input pointer list");
    json::JsonObj obj;
    json::JData tmp;
    try
    {
        for(vmp_index i=0;i<list->get_array_size();i++)
        {
            list->get_array_idx(i,&obj);
            tmp.set(&obj);
            if((jtype != "") && (tmp.jtype() != jtype))
                vmp::except_s("");
        }
        reset();
        list_=list;
        jtype_=jtype; 
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("json::JList::set() input list bad object");
    }
}

json::JsonObj *JList::list()
{
    check_init("list");
    return list_;
}

vmp::str JList::jdata_type()
{
    check_init("jdata_type");
    return jtype_;
}

void JList::push(json::JsonObj *jdata)
{
    check_init("push");
    vmp::except_check_pointer((void *) jdata,"json::JList::push() null input pointer jdata");
    try
    {
        json::JData tmp;
        tmp.set(jdata);
        if((jtype_ != "") && (tmp.jtype() != jtype_))
            vmp::except_s("");
        list_->push_array_obj_ex(jdata);	
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("json::JList::push() input jdata bad values");
    }
        
}
         
void JList::replace(vmp_index i,json::JsonObj *jdata)
{
    check_init("replace");
    vmp::except_check_pointer((void *) jdata,"json::JList::replace() null input pointer jdata");
    try
    {
        json::JData tmp;
        tmp.set(jdata);
        if((jtype_ != "") && (tmp.jtype() != jtype_))
            vmp::except_s("");
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("json::JList::replace() input jdata bad values");
    }
    if(!list_->replace_array_obj_ex(i,jdata))
        vmp::except_s("json::JList::replace() index out bound range");
}
         
void JList::get(vmp_index i,json::JsonObj *jdata)
{
    check_init("get");
    vmp::except_check_pointer((void *) jdata,"json::JList::get() null input pointer jdata");
    if(!list_->get_array_idx(i,jdata))
        vmp::except_s("json::JList::get() index out bound range");
}

vmp_size JList::size()
{
    check_init("size");
    return list_->get_array_size();
}

}}

