/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/05/2020
 */

#ifndef VAMPIRIA_EVENT_EVENTTIMER_H

#define VAMPIRIA_EVENT_EVENTTIMER_H 1

namespace vampiria { namespace event {

//!Event timer
class EventTimer:public event::Event
{
    public:
        //!A Constructor
        EventTimer();

        //!A Destructor
        ~EventTimer();

        vmp::time::Time timeval_;/*!<Time interval to active event*/
        vmp::time::Time timeactive_;/*!<event activation time*/

        event::EVTCB event_;/*!<Callback performed when the event is triggered*/

        //!Create a new event timer
        /*!
            @param  ui    user interface (see Class UI)
            @param  timeval time interval to active event(> 0.0)
            @param  event callback performed on active timer event
            @param  close function performed at the end of the event
            @return the new cell associated with the event(except error)
        */
        event::Cell *evt_timer_new(event::UI *ui,vmp::time::Time timeval,event::EVTCB event,event::EVTCB close);

        //!Active timer event.If already active set the new time
        /*!
            @param timeval time interval to active event
            @return void(except error)
        */
        void evt_timer_active(vmp::time::Time timeval);
        
        //!Deactive timer event.To reactivate it, use evt_timer_active
        void evt_timer_deactive();

        //! Close Timer event
        void evt_timer_close();

        //! Free Timer event
        void evt_timer_free();
};

}}

#endif

