/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/05/2020
 */

#include "event.h"

namespace vampiria { namespace event {

Cell::Cell()
{
     reset();
}

Cell::~Cell()
{
}

void Cell::reset()
{
    state_=event::ACTIVE;
    timeout_=0.0;
    timewait_=0.0;
    nwait_=0;
    ret_=event::NOCLOSE;
    err_="";
    refalloc_=0;
    priority_=0;
    
    ui_=0;
    event_=0;
    manager_=0;
    priority_=0;
    read_=0;
    close_=0;
    
    writing_=false;
    evtype_="";
}

vmp::str Cell::identity()
{
   manager_->lock();
   vmp::str ret=ui_->identity(this); 
   manager_->unlock();
   return ret;
}

void Cell::close()
{
    manager_->lock();
    manager_->cell_close(this,event::SUCCESS);
    manager_->unlock();
}

void Cell::close_wait(vmp_uint n)
{
    manager_->lock();
    manager_->cell_closewait(this,n);
    manager_->unlock();
}

void Cell::close_err(vmp::str err)
{
    manager_->lock();
    manager_->cell_close(this,event::ERROR,err);
    manager_->unlock();
}

void Cell::alloc()
{
    manager_->lock();
    manager_->cell_alloc(this);
    manager_->unlock();
}

void Cell::release()
{
    manager_->lock();
    manager_->cell_release(this);
    manager_->unlock();
}

event::CELLRET Cell::ret()
{
    manager_->lock();
    event::CELLRET ret=ret_;
    manager_->unlock();
    return ret;
}

vmp::str Cell::str_error()
{
    manager_->lock();
    vmp::str ret=err_;
    manager_->unlock();
    return ret;
}

void Cell::set_timewait(vmp::time::Time timewait)
{
    manager_->lock();
    manager_->cell_timewait(this,timewait);
    manager_->unlock();
}

vmp::time::Time Cell::get_timewait()
{
    manager_->lock();
    vmp::time::Time ret=timewait_;
    manager_->unlock();
    return ret;
     
}

event::Manager *Cell::get_manager()
{
    return manager_;
}

vmp_bool Cell::operator()(Cell *&c1,Cell *&c2)
{
    if(c1->priority_ < c2->priority_)
       return true;
    return false;
}

}}

