/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 05/03/2020
 */

#include "vmp.h"
#include "pylib.h"
#include "xml.h"

#ifndef VAMPIRIA_PY_XML_H

#define VAMPIRIA_PY_XML_H 1

//!Python wrapper of the c++ namespace vampiria::xml in vmp_xml.(see c++ doc)
/*!
    Function c++ in xml.h:<BR>
*/
void xml_init(pylib::Module module);

//!Python wrapper of the c++ class vampiria::xml::Tag in vmp_xml_.Tag and c++ class vampiria::xml::Parser in vmp_xml.Parser(see c++ doc)
/*!
    Function def create_tag(pyobject,priority)<BR>Create a tag dynamically.Used in the pure python Tag class to associate a PyTag.<BR>
    @param pyobject object in pure python where it is called.
    @param priority priority build tag
    @return new pytag associated with python pure pyobject
*/
/*!
     Tag class in xml.h:<BR>No Constructor<BR>
     Tag member function list:<BR>get_filepath(),get_line(),get_name(),get_text(),get_attr(),get_attrs_name()<BR>
     get_parent(),get_child(),get_child_number(),parser_error()
*/
/*!
     Parser class in xml.h(DomParser virtual):<BR>Constructor Parser()<BR>
     Parser member function add_tag(name,objtype)<BR>
     Adds a python type object. The object must come from the vmp_net.Tag class. The name parameter is the name associated with the tag type, the objtype parameter the typed object.<BR><BR>
     Parser member function list:<BR>get_root(),build(),destroy()
*/
void xml_init_parser(pylib::Module module);

//!Python wrapper of the c++ class vampiria::xml::WTag in vmp_xml.WTag and c++ class vampiria::xml::WParser in vmp_xml.WParser(see c++ doc)
/*!
     WTag class in xml.h:<BR>No Constructor<BR>
     WTag member function list:<BR>set_text(),add_attr(),add_child(),set_parent(),get_parent()
*/
/*!
     WParser class in xml.h:<BR>Constructor WParser()<BR>
     WParser member function list:<BR>init(),write()
*/
void xml_init_wparser(pylib::Module module);

#endif

