/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 17/06/2022
 */

#include "json_.h"

struct stub_japi_list:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             json::JsonObj *obj=args.get<json::JsonObj *>(0);
             json::japi_list(obj);
             return pylib::retnone();
         }
         else if(args.size() == 2)
         {
             json::JsonObj *obj=args.get<json::JsonObj *>(0);
             vmp::str datatype;
             json::JList *list=0;
             try
             {
                 datatype=args.get<vmp::str>(1);
             }
             catch(vmp::exception &x)
             {
                 list=args.get<json::JList *>(1);
             }
             if(list == 0)
                 json::japi_list(obj,datatype);
             else
                 json::japi_list(obj,list);
             return pylib::retnone();    
         }
         return 0;
    }
};

struct stub_japi_table:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             json::JsonObj *obj=args.get<json::JsonObj *>(0);
             json::japi_table(obj);
             return pylib::retnone();
         }
         else if(args.size() == 2)
         {
             json::JsonObj *obj=args.get<json::JsonObj *>(0);
             vmp::str datatype;
             json::JTable *table=0;
             try
             {
                 datatype=args.get<vmp::str>(1);
             }
             catch(vmp::exception &x)
             {
                 table=args.get<json::JTable *>(1);
             }
             if(table == 0)
                 json::japi_table(obj,datatype);
             else
                 json::japi_table(obj,table);
             return pylib::retnone();    
         }
         return 0;    
     }
};

void json_japi(pylib::Module module)
{
    module.def_("japi",json::japi);
    module.def_("japi_void",json::japi_void);
    module.def_with_stub("japi_list",stub_japi_list());
    module.def_with_stub("japi_table",stub_japi_table());
}

