/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 10/05/2020
 */

#include "event_.h"

void event_init_manager(pylib::Module module)
{
    //event.h 
    pylib::Class<event::Manager> manager=module.class_<event::Manager>("Manager");
    manager.def_("lock",&event::Manager::lock);
    manager.def_("unlock",&event::Manager::unlock);
    manager.def_("time_now",&event::Manager::time_now);
    manager.def_("breakloop",&event::Manager::breakloop);
    manager.def_("stop",&event::Manager::stop);
    manager.def_("loop",&event::Manager::loop);
}

struct stub_cell_ret:public pylib::Member_def<event::Cell>
{
    pylib::Objref *def(event::Cell *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
        {
            vmp_int ret=-1;
            switch(instance->ret())
            {
                case event::SUCCESS:
                    ret=0;
                    break;
                case event::ERROR:
                    ret=1;
                    break;
                case event::TIMEOUT:
                    ret=2;
                    break;
                default: 
                    ret=-1;
                    break;
            }
            return pylib::Converter<vmp_int>(ret); 
        }
        return 0;
    }
};

struct stub_cell_setvar:public pylib::Member_def<event::Cell>
{
    pylib::Objref *def(event::Cell *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str key=args.get<vmp::str>(0);
            pylib::PyObj *obj=new pylib::PyObj();
            args.get_obj(1,(*obj));
            try
            {
                instance->setvar<pylib::PyObj>(key,obj);
            }
            catch(vmp::exception &x)
            {
                delete obj;
                vmp::except_s(x.what());
            }
            return pylib::retnone(); 
        }
        return 0;
    }
};

struct stub_cell_getvar:public pylib::Member_def<event::Cell>
{
    pylib::Objref *def(event::Cell *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str key=args.get<vmp::str>(0);
            pylib::PyObj *ret=instance->getvar<pylib::PyObj>(key);
            if(ret == 0)
                return pylib::retnone();
            return pylib::Converter<pylib::Objref *>(ret->ref());
        }
        return 0;
    }
};

struct stub_cell_remvar:public pylib::Member_def<event::Cell>
{
    pylib::Objref *def(event::Cell *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str key=args.get<vmp::str>(0);
            pylib::PyObj *ret=instance->remvar<pylib::PyObj>(key);
            if(ret == 0)
                return pylib::retnone();
            pylib::Objref *rvalue=pylib::Converter<pylib::Objref *>(ret->ref());
            delete ret;
            return rvalue;
        }
        return 0;
    }
};

VAMPIRIA_PYLIB_INIT(vmp_event_);

void event_init_cell(pylib::Module module)
{
    //CELLRET enum in event.h
    module.add_const<vmp_int>("CELLRET_NOCLOSE",-1);
    module.add_const<vmp_int>("CELLRET_SUCCESS",0);
    module.add_const<vmp_int>("CELLRET_ERROR",1);
    module.add_const<vmp_int>("CELLRET_TIMEOUT",2);

    //event.h
    pylib::Class<event::Cell> cell=module.class_no_constructor<event::Cell>("Cell");
    cell.def_("identity",&event::Cell::identity);
    cell.def_("close",&event::Cell::close);
    cell.def_("close_wait",&event::Cell::close_wait);
    cell.def_("close_err",&event::Cell::close_err);
    cell.def_("alloc",&event::Cell::alloc);
    cell.def_("release",&event::Cell::release);
    cell.def_with_stub("ret",stub_cell_ret());
    cell.def_("str_error",&event::Cell::str_error);
    cell.def_("set_timewait",&event::Cell::set_timewait);
    cell.def_("get_timewait",&event::Cell::get_timewait);
    cell.def_("get_manager",&event::Cell::get_manager,false);
    cell.def_with_stub("setvar",stub_cell_setvar());
    cell.def_with_stub("getvar",stub_cell_getvar());
    cell.def_with_stub("remvar",stub_cell_remvar());
    cell.def_("all_keys",&event::Cell::all_keys);
}

void vampiria_pylib_init_module(pylib::Module init_module)
{
    event_init_manager(init_module);
    event_init_cell(init_module);
    event_init_inputui(init_module);
    event_init_timerui(init_module);
    event_init_simplexui(init_module);
    event_init_threadui(init_module);     
}


