#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 24/10/2019

import vmpconfig as config
import vmpbuild  as build

##Software name
name="example_c"

##Build setup object
setup=build.setup()
##Software name
setup.name=name
##path root directory software
setup.path=config.gsoftware_path(name)
##files .cc to compile [('directory da setup.path',['main',...]),...]
setup.files=[('./',['main'])]
##directory to make exe or .so files
setup.dirtarget=config.gexec_
## False exe file,true .so library
setup.shared=False
##framework or package dependencies
setup.dependencies=['vmp']
##Compiler options ['-lutils',....]
setup.coptions=[]
##Linker options ['`pkg-config --libs libevent_openssl`',...]
setup.loptions=[]
##command verify ['xterm -h',....]
setup.cmd=[]
##header user ['stdio.h',....]
setup.hdr=[]
##verify check if a library is installed (use pkg-config) [('python3','3.5'),...]
setup.libs=[]
##Config file create (filename,['string list one a line',...])
setup.config=()

def description():
    return "description software"

##Compile and linking
def install():
    build.cbuild(setup)

##Remove
def uninstall():
    build.cclear(setup)

