#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 13/06/2020

import vmp

from tkinter  import filedialog
from tkinter  import messagebox as mbox

##Creates an file dialog object
#
#@param parent frame parent
#@param title frame dialog title
#@param initdir initial directory
#@param filetypes extension file [("description","*.ext"),..]
#@return path file selected or None if file is not select
def ask_openfilename(parent,title,initdir,filetypes=None):
  if filetypes is None:
    filepath=filedialog.askopenfilename(parent=parent,title=title,initialdir=initdir)
  else:
    filepath=filedialog.askopenfilename(parent=parent,title=title,initialdir=initdir,filetypes=filetypes)
  if (filepath == ()) or (filepath == ''):
    return None
  return filepath

##Popup for directory selection
#
#@param parent frame parent
#@param title frame dialog title
#@param initdir initial directory
#@return path directory selected or None if directory is not select
def ask_directory(parent,title,initdir):
  dirpath=filedialog.askdirectory(parent=parent,title=title,mustexist=True,initialdir=initdir)
  if not ((dirpath == ()) or (dirpath == '')):
    if not (dirpath[len(dirpath)-1] == '/'):
      dirpath="{0}/".format(dirpath)
    return dirpath
  return None

##Save file dialog
#
#@param parent frame parent
#@param title frame dialog title
#@param initdir initial directory
#@param filetypes extension file [("description","*.ext"),..]
#@return path file selected or None if file is not select
def ask_saveasfilename(parent,title,initdir,filetypes=None):
  if filetypes is None:
    filepath=filedialog.asksaveasfilename(parent=parent,title=title,initialdir=initdir)
  else:
    filepath=filedialog.asksaveasfilename(parent=parent,title=title,initialdir=initdir,filetypes=filetypes)
  if (filepath == ()) or (filepath == ''):
    return None
  return filepath

##Showerror message box
#
#@param title frame dialog title
#@param error error message
#@param parent frame parent
def showerror(title="",error="",parent=None):
  if parent is None:  
    mbox.showerror(title,error)
  else:
    mbox.showerror(title,error,parent=parent)

##Ask the users a question
#@param title frame dialog title
#@param question question with answer yes or no
#@param return true if accepted question,otherwise false
def askquestion(title="",question="",parent=None):
  if parent is None:
    result=mbox.askquestion(title,question)
  else:
    result=mbox.askquestion(title,question,parent=parent)
  if result == 'yes':
    return True
  return False

