/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 18/03/2020
 */

#include "../main.h"

StderrTag::StderrTag():xml::Tag()
{
    set_priority(60);
}
       
StderrTag::~StderrTag()
{
}

       
void StderrTag::build()
{
    Vampiria *vmp=vmp::Instance::get_global<Vampiria>();
    ProcessTag *ptag=(ProcessTag *) get_parent();
    process::StdW *err;
    vmp::str file=get_attr("file");
    if(file == "")
        err=vmp->stdwfactory_.err();
    else
    {
        try
        {
            err=vmp->stdwfactory_.file(file);
        }
        catch(vmp::exception &x)
        {
            parser_error("Attribute file='%s' error:%s",file.c_str(),x.what());
        }   
    }
    ptag->process_->add_stderr(err);
}

StdoutTag::StdoutTag():xml::Tag()
{
    set_priority(60);
}
       
StdoutTag::~StdoutTag()
{
}

       
void StdoutTag::build()
{
    Vampiria *vmp=vmp::Instance::get_global<Vampiria>();
    ProcessTag *ptag=(ProcessTag *) get_parent();
    process::StdW *out=vmp->stdwfactory_.out();
    ptag->process_->add_stdout(out);
}

FileoutTag::FileoutTag():xml::Tag()
{
    set_priority(60);
}
       
FileoutTag::~FileoutTag()
{
}

       
void FileoutTag::build()
{
    vmp::str file=get_attr("file");
    Vampiria *vmp=vmp::Instance::get_global<Vampiria>();
    ProcessTag *ptag=(ProcessTag *) get_parent();
    try
    {
        process::StdW *fout=vmp->stdwfactory_.file(file);
        ptag->process_->add_stdout(fout);
    }
    catch(vmp::exception &x)
    {
        parser_error("Attribute file='%s' error: %s",file.c_str(),x.what());
    }
}

ProcessoutTag::ProcessoutTag():xml::Tag()
{
    set_priority(60);
}
       
ProcessoutTag::~ProcessoutTag()
{
}

       
void ProcessoutTag::build()
{
    Vampiria *vmp=vmp::Instance::get_global<Vampiria>();
    vmp::str id=get_attr("id");
    ProcessoutTag *tmp;
    Process *pin;
    ProcessTag *ptag=(ProcessTag *) get_parent();
    if((pin=vmp->get_process(id)) == 0)
        parser_error("Attribute id='%s' error: unbound process",id.c_str());
    if(ptag->pout_.search(id,&tmp))
        parser_error("Attribute id='%s' error: duplicate process id prev line '%u'",id.c_str(),tmp->get_line());
    ptag->pout_.insert(id,this);
    process::StdW *box=vmp->stdwfactory_.box(pin);
    ptag->process_->add_pout(box,pin);
}

