/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 18/03/2020
 */

#include "../main.h"

PutenvTag::PutenvTag()
{
    set_priority(80);
}
        
PutenvTag::~PutenvTag()
{
}

void PutenvTag::build()
{
    ProcessTag *ptag=(ProcessTag *) get_parent();
    PutenvTag *tmp;
    vmp::str name;
    try
    {
        name=ptag->process_->envp_.insert_data(get_text(),true);
    }
    catch(vmp::exception &x)
    {
        parser_error("Tag Text error: %s",x.what());
    }
    if(ptag->putenv_.search(name,&tmp))
        parser_error("Tag Text error: Duplicate Enviroment variable name '%s' prev '%u'",name.c_str(),tmp->get_line());
    ptag->putenv_.insert(name,this);
}

PreloadTag::PreloadTag()
{
    set_priority(70);
}
        
PreloadTag::~PreloadTag()
{
}

void PreloadTag::build()
{
    vmp::str libname=get_text();
    ProcessTag *ptag=(ProcessTag *) get_parent();
    PreloadTag *tmp;
    if(ptag->preload_.search(libname,&tmp))
        parser_error("Tag Text error: Duplicate load lib '%s' prev '%u'",libname.c_str(),tmp->get_line());       
    ptag->preload_.insert(libname,this);
    try
    {
        ptag->process_->envp_.preload_local_lib(libname);
    }
    catch(vmp::exception &x)
    {
        parser_error("Tag Text error: %s",x.what());
    }
}

ImportTag::ImportTag()
{
    set_priority(60);
}
        
ImportTag::~ImportTag()
{
}

void ImportTag::build()
{
    vmp::str stmp;
    ProcessTag *ptag=(ProcessTag *) get_parent();
    vmp::str file=get_attr("file");
    vmp::str name=get_attr("name");
    stmp=vmp::unicode::str_extract_char(name,"./");
    if(stmp != "")
        parser_error("Attribute name='%s' error: contains the following invalid characters '%s'",name.c_str(),stmp.c_str());
    vmp::unicode::str_write(&name,"%s%s",ptag->process_->rootdir_.c_str(),name.c_str());
    try
    {
        vmp::vector<vmp::str> data;
        data=vmp::input_file(file);
        vmp::str idata=vmp::unicode::str_join(data,"\n");
        vmp::output_file(name,false,"%s\n",idata.c_str());
    }
    catch(vmp::exception &x)
    {
        parser_error("Attribute file='%s' error:%s",file.c_str(),x.what());
    }
}

ExportTag::ExportTag()
{
    set_priority(60);
}
        
ExportTag::~ExportTag()
{
}

void ExportTag::build()
{
    ProcessTag *ptag=(ProcessTag *) get_parent();
    vmp::str stmp;
    vmp::str file=get_attr("file");
    vmp::str name=get_attr("name");
    stmp=vmp::unicode::str_extract_char(name,"./");
    if(stmp != "")
        parser_error("Attribute name='%s' error: contains the following invalid characters '%s'",name.c_str(),stmp.c_str());
    vmp::unicode::str_write(&name,"%s%s",ptag->process_->rootdir_.c_str(),name.c_str());
    try
    {
        vmp::output_file(file,true,"");
    }
    catch(vmp::exception &x)
    {
        parser_error("Attribute file='%s' error: %s",file.c_str(),x.what());
    }
    ptag->process_->exports_.push_back(vmp::pair<vmp::str,vmp::str>(file,name));  
}

KillTag::KillTag()
{
    set_priority(60);
}
        
KillTag::~KillTag()
{
}

void KillTag::build()
{
   Vampiria *vmp=vmp::Instance::get_global<Vampiria>();
   ProcessTag *ptag=(ProcessTag *) get_parent();
   vmp::str id=get_attr("id");
   vmp::str signal=get_attr("signal");
   if(signal == "")
       signal="sigint";
   if(id == ptag->process_->id())
       parser_error("Attribute id='%s' error:local process id",id.c_str());
   Process *ref=vmp->get_process(id);   
   if(ref == 0)
       parser_error("Attribute id='%s' error:process id not found",id.c_str());
   ptag->process_->kill_.push_back(vmp::pair<vmp::str,vmp::str>(id,signal));
}

