/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 18/03/2020
 */

#include "../main.h"

VampiriaTag::VampiriaTag():xml::Tag()
{
    set_priority(100);
}
        
VampiriaTag::~VampiriaTag()
{
}

void VampiriaTag::build()
{
    Vampiria *vmp=vmp::Instance::get_global<Vampiria>();
    vmp::str root=vmp->get_root();
    vmp::debug("Build root directory '%s'",root.c_str());   
}

ProcessTag::ProcessTag():xml::Tag()
{
    set_priority(90);
}
        
ProcessTag::~ProcessTag()
{
}

void ProcessTag::destroy_impl()
{
    pout_.clear();
    process_=0;
    putenv_.clear();
    preload_.clear();
}
        
void ProcessTag::build()
{
    Vampiria *vmp=vmp::Instance::get_global<Vampiria>();
    vmp::str id=get_attr("id");
    vmp_bool init;
    process::BOX_COM comtype;
    vmp::str tmp=get_attr("init");
    if((tmp == "") || (tmp == "no"))
       init=false;
    else
       init=true;
    tmp=get_attr("comtype");
    if((tmp == "") || (tmp == "pipe"))
       comtype=process::BOX_PIPE;
    else
       comtype=process::BOX_PTS;
    process_=vmp->add_process(this,id,init,comtype);   
}

