/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 19/11/2020
 */

#include "packet.h"

namespace vampiria { namespace packet {

Udp_P::Udp_P():packet::Packet(packet::P_UDP)
{
    // data_[0]
    packet::DataSize *srcport=new packet::DataSize("srcport",2);
    insert_data(srcport);
	
    //data_[1]
    packet::DataSize *dstport=new packet::DataSize("dstport",2);
    insert_data(dstport);
     
    //data_[2]
    packet::DataSize *length=new packet::DataSize("length",2);
    length->set("length","8");
    insert_data(length);
	
    //data_[3]
    packet::DataHexSize *checksum=new packet::DataHexSize("checksum",2);
    insert_data(checksum);
}

Udp_P::~Udp_P()
{
}

void Udp_P::pseudo_header(vmp::Buf *buf)
{
    vmp::except_check_pointer((void *) buf,"packet::Udp_P::pseudo_header() null input pointer buf");
    buf->index(buf->size()-2);
    try
    {
        packet::DataSize *length=(packet::DataSize *) data_[2];
        vmp_size plen=buf->read_size(2);
        if(length->get_data() != plen)
            vmp::except_s("");
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("packet::Udp_P::pseudo_header() invalid header length values");   
    }
    data_[0]->write(buf);
    data_[1]->write(buf);
    data_[2]->write(buf);
}

Tcp_P::Tcp_P():packet::Packet(packet::P_TCP)
{
        //data_[0]
        packet::DataSize *srcport=new packet::DataSize("srcport",2);
        insert_data(srcport);
	
        //data_[1]
        packet::DataSize *dstport=new packet::DataSize("dstport",2);
        insert_data(dstport);
	
        //data_[2]
        packet::DataSize *sequence_n=new packet::DataSize("sequence_n",4);
        insert_data(sequence_n);
	
        //data_[3]
        packet::DataSize *ack_n=new packet::DataSize("ack_n",4);
        insert_data(ack_n);
	
        // data_[4]
        packet::DataBits *bits4=new packet::DataBits(1);
        packet::BitSize *offset=new packet::BitSize("offset",4,4);
        bits4->insert_data(offset);
        packet::BitHexSize *reserved=new packet::BitHexSize("reserved",0,4);
        bits4->insert_data(reserved);
        insert_data(bits4);
      
         //data_[5]
        packet::DataBits *flags=new packet::DataBits(1);
        packet::BitSelect *cwr=new packet::BitSelect("cwr",7,1);
        cwr->insert_code("unset",0);
        cwr->insert_code("set",1);
        flags->insert_data(cwr);
	packet::BitSelect *ece=new packet::BitSelect("ece",6,1);
        ece->insert_code("unset",0);
        ece->insert_code("set",1);
        flags->insert_data(ece);
	packet::BitSelect *urg=new packet::BitSelect("urg",5,1);
        urg->insert_code("unset",0);
        urg->insert_code("set",1);
        flags->insert_data(urg);
        packet::BitSelect *ack=new packet::BitSelect("ack",4,1);
        ack->insert_code("unset",0);
        ack->insert_code("set",1);
        flags->insert_data(ack);	
	packet::BitSelect *psh=new packet::BitSelect("psh",3,1);
        psh->insert_code("unset",0);
        psh->insert_code("set",1);
        flags->insert_data(psh);
	packet::BitSelect *rst=new packet::BitSelect("rst",2,1);
        rst->insert_code("unset",0);
        rst->insert_code("set",1);
        flags->insert_data(rst);
        packet::BitSelect *syn=new packet::BitSelect("syn",1,1);
        syn->insert_code("unset",0);
        syn->insert_code("set",1);
        flags->insert_data(syn);
        packet::BitSelect *fin=new packet::BitSelect("fin",0,1);
        fin->insert_code("unset",0);
        fin->insert_code("set",1);
        flags->insert_data(fin);		
	insert_data(flags); 
	
        //data_[6]
        packet::DataSize *window=new DataSize("window",2);
        insert_data(window);     
 
	// data_[7]
	packet::DataHexSize *checksum=new DataHexSize("checksum",2);
        insert_data(checksum);
	
	// data_[8]
	packet::DataSize *urgent_p=new packet::DataSize("urgent_p",2);
        insert_data(urgent_p);
	
	// data_[9]
        packet::DataBuffer *options=new packet::DataBuffer("options");
        insert_data(options);
}

Tcp_P::~Tcp_P()
{
}

void Tcp_P::read(vmp::Buf *buf)
{
     for(vmp_index i=0;i<data_.size()-1;i++)
         data_[i]->read(buf);
     vmp_size offset=((packet::DataBits *)data_[4])->get_data("offset");
     vmp_size optlen=0;
     if(offset > 5)
        optlen=(offset-5)*4;
     packet::DataBuffer *options=(packet::DataBuffer *) data_[9];   
     options->read_size_data(buf,optlen);	
}

void Tcp_P::set(vmp::str field,vmp::str data)
{
     vmp_index index;
     if(!search_.search(field,&index))
        vmp::except("packet::Packet::set() the '%s' package does not have a field called '%s'",type_.c_str(),field.c_str());
     try
     {
        if(field == "options")
        {
            if(data.size() > 40)
                vmp::except_s("data length too large(<=40)");
            vmp_size rest=data.size() % 4;
            data_[9]->set(field,data);
            packet::DataBuffer *options=(packet::DataBuffer *) data_[9];
            vmp::Buf *buf=options->get_data();
            if(rest != 0)
                buf->newsize(buf->size()+4-rest);
            vmp_size offset=5+(buf->size()/4);
            packet::DataBits *f1=(packet::DataBits *) data_[4];
            f1->set_data("offset",offset);
        }
        else
        {
            data_[index]->set(field,data);
            if(field == "offset")
            {
                vmp_size offset=((packet::DataBits *)data_[4])->get_data("offset");
                vmp_size optlen=0;
                if(offset > 5)
                    optlen=(offset-5)*4;
                packet::DataBuffer *options=(packet::DataBuffer *) data_[9];
                vmp::Buf *buf=options->get_data();
                buf->newsize(optlen);
            }
        }
    }
    catch(vmp::exception &x)
    {
        vmp::except("packet::Packet::set() in packet '%s' check failed to insert data '%s' for field '%s'[%s]",
                        type_.c_str(),data.c_str(),field.c_str(),x.what());
    }
}

void Tcp_P::pseudo_header(vmp::Buf *buf)
{
    vmp::except_check_pointer((void *) buf,"packet::Tcp_P::pseudo_header() null input pointer buf");
    buf->index(buf->size()-2);
    try
    {
        packet::DataBuffer *options=(packet::DataBuffer *)data(9);
        vmp::Buf bpayload;
        payload(&bpayload);
        vmp_size len=20 + options->get_data()->size() + bpayload.size();
        vmp_size plen=buf->read_size(2);
        if(len != plen)
            vmp::except_s("");
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("packet::Tcp_P::pseudo_header() invalid header length values");   
    }
    data_[0]->write(buf);
    data_[1]->write(buf);
    data_[2]->write(buf);
    data_[3]->write(buf);
    data_[4]->write(buf);
    data_[5]->write(buf);
    data_[6]->write(buf);
    data_[8]->write(buf);
    data_[9]->write(buf);
}

}}

