/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 13/11/2020
 */

#include "packet.h"

namespace vampiria { namespace packet {

BitSize::BitSize(vmp::str field,vmp_byte init,vmp_byte size):packet::Bitwise(field,init,size)
{
}
        
BitSize::~BitSize()
{
}

vmp::str BitSize::get(vmp_size data)
{
    vmp::str ret;
    vmp::unicode::str_write(&ret,"%u",data);
    return ret;    
}
        
vmp_size BitSize::set(vmp::str data)
{
    return ((vmp_size)vmp::unicode::str_todigit_range(data,0,(vmp_int)(vmp::math::pow_wrap(2,size())-1)));
}

BitHexSize::BitHexSize(vmp::str field,vmp_byte init,vmp_byte size):packet::Bitwise(field,init,size)
{
}
        
BitHexSize::~BitHexSize()
{
}

vmp::str BitHexSize::get(vmp_size data)
{
    vmp::str ret="";
    vmp_size s=size();
    vmp_size datalen=s/4;
    if((s %4) != 0)
	datalen +=1;
    switch(datalen)
    {
        case 1:
           vmp::unicode::str_write(&ret,"%01X",data);
           break;
        case 2:
           vmp::unicode::str_write(&ret,"%02X",data);
           break;
        case 3:
           vmp::unicode::str_write(&ret,"%03X",data);
           break;
        case 4:
           vmp::unicode::str_write(&ret,"%04X",data);
           break;
	case 5:
           vmp::unicode::str_write(&ret,"%05X",data);
           break;
	case 6:
           vmp::unicode::str_write(&ret,"%06X",data);
           break;
	case 7:
           vmp::unicode::str_write(&ret,"%07X",data);
           break;
	case 8:
           vmp::unicode::str_write(&ret,"%08X",data);
           break;
        default:
           break;
    }
    return ret;
}
        
vmp_size BitHexSize::set(vmp::str data)
{
    vmp_size s=size(),sdata=0;
    vmp_size datalen=s/4;
    if((s %4) != 0)
	datalen +=1;
    try
    {
        if(data.size() != datalen)
            vmp::except_s("");
        vmp::vector<vmp_byte> bytes=vmp::unicode::xstr_tobytes(data);
        sdata=0;
        for(vmp_index i=0;i<bytes.size();i++)
        {    
            sdata=sdata <<  8;
            sdata += bytes[i];
        }
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("Malformed data Bit hex size");
    }
    return sdata;	
}

BitSelect::BitSelect(vmp::str field,vmp_byte init,vmp_byte size):packet::Bitwise(field,init,size)
{
}

BitSelect::~BitSelect()
{
    code_.clear();
    name_.clear();
}

vmp::str BitSelect::get(vmp_size data)
{
    vmp::str ret;
    if(!code_.search(data,&ret))
        return "not found";
    return ret;
}
        
vmp_size BitSelect::set(vmp::str data)
{
    vmp_size code;
    if(!name_.search(data,&code))
        vmp::except_s("Data not found");
    return code;
}

void BitSelect::insert_code(vmp::str name,vmp_size code)
{
    if(code > (vmp::math::pow_wrap(2,size()) -1))
        vmp::except_s("Code too large");
    code_.insert(code,name);
    name_.insert(name,code);
}

}}

