/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 06/06/2020
 */

#ifndef VAMPIRIA_NET_SOCKET_H

#define VAMPIRIA_NET_SOCKET_H 1

namespace vampiria { namespace net {

typedef vmp_int Socket;/*!<Socket type(see linux doc)*/

//! Create datagram socket (see socket linux doc).
/*!
    @param domain specifies a communication domain(AF_INET,AF_INET6 etc..)
    @param blocking socket is blocking?
    @return new socket datagram (except error) 
*/
net::Socket socket_datagram(vmp_int domain,vmp_bool blocking);

//! Create stream socket (see socket linux doc)
/*!
    @param domain specifies a communication domain(AF_INET,AF_INET6 etc..)
    @param blocking socket is blocking?
    @return new socket datagram (except error) 
*/
net::Socket socket_stream(vmp_int domain,vmp_bool blocking);

//! Connects the socket sock to the address specified by remote.
/*!
    @param sock socket to connect
    @param remote address to connect
    @return true if the connection is made, false if the connection is on hold(except error)
*/
vmp_bool socket_connect(net::Socket sock,net::Address *remote);

//! Check if the connection is complete(socket non blocking)
/*!
    @param sock socket to connect
    @return true if the connection is made, false if the connection is on hold(except error)
*/
vmp_bool socket_connect_check(net::Socket sock);

//!Assigns the address  specified  by  local  to the socket sock
/*!
    @param sock socket to bind
    @param local address to bind
    @return void (except to error)
*/ 
void socket_bind(net::Socket sock,net::Address *local);

//!Marks the  socket referred to by sock as a passive socket,that is, as a socket that will be used to  accept  incoming  connection
/*!
    @param sock socket to listen
    @param backlog  the maximum length to which the  queue  of pending  connections 
*/
void socket_listen(net::Socket sock,vmp_uint backlog);

//! It extracts the  first  connection  request  on  the  queue  of pending connections for the listening socket
/*!
    @param sock listen socket
    @param blocking socket connection is blocking?
    @return socket connection,-1 no connection accepting(non blocking socket).(except error)
   
*/
vmp_int socket_accept(net::Socket sock,vmp_bool blocking);

//!Gets socket address local
/*!
    @param sock input socket
    @param result address result
    @return void (except error)
*/
void socket_addrlocal(net::Socket sock,net::Address *result);

//!Gets socket address peer
/*!
    @param sock input socket
    @param result address result
    @return void (except error)
*/
void socket_addrpeer(net::Socket sock,net::Address *result);

//!Close socket connection
/*!
    @param socket pointer socket arguments(set socket = -1)
*/
void socket_close(net::Socket *socket);

//! Sets the timeout when a socket is received
/*!
    @param sock socket input
    @param timeout timeout value > 0.0
    @return void or except in case of failure
*/
void socket_timeout(net::Socket sock,vmp::time::Time timeout);

}}

#endif

