/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 25/02/2020
 */

#include "vmp.h"
#include "event.h"

#include <sys/socket.h>
#include <netdb.h>

#include "net/address.h"
#include "net/socket.h"

#ifndef VAMPIRIA_NET_H

#define VAMPIRIA_NET_H 1

namespace vampiria { namespace net {

typedef void (*EVTCBRECVFROM)(event::Cell *cell,vmp::Buf *buf,net::Address *peer);/*<!Event recvfrom callback(see framework event)*/
typedef void (*EVTCBRECV)(event::Cell *cell,vmp::Buf *buf);/*<!Event recv callback (see framework event)*/
typedef void (*EVTCBACCEPT)(event::Cell *listen,event::Cell *server);/*<!Event accept callback (see framework event)*/

//! Empty EVTCBRECVFROM callback
void empty_recvfrom_ev(event::Cell *cell,vmp::Buf *buf,net::Address *peer);

//! Empty EVTCBRECV callback
void empty_recv_ev(event::Cell *cell,vmp::Buf *buf);

//! Empty EVTCBACCEPT callback
void empty_accept_ev(event::Cell *listen,event::Cell *server);

}}

#endif

#include "net/netdevice.h"
#include "net/udp.h"
#include "net/tcp.h"
#include "net/dns.h"



