/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 15/05/2020
 */

#ifndef VAMPIRIA_EVENT_BREAKLOOPUI_H

#define VAMPIRIA_EVENT_BREAKLOOPUI_H 1

namespace vampiria { namespace event {

//!Breakloop User interface(Used from Manager)
class BreakloopUI:public event::UI
{
    private:
      friend event::Manager;
      event::Cell *cell_;/*<Cell associated with the only event*/
      event::EventPipe evtpipe_;/*<Event pipe associated*/

      //!Active breakloop
      void active();
    public:
      //!A Constructor
      /*!
           @param manager associated manager
      */
      BreakloopUI(event::Manager *manager);

      //!A Destructor
      ~BreakloopUI();

      //!Virtual class implemented
      vmp::str identity(event::Cell *cell);
      
      //!Virtual class implemented
      void close_event(event::Cell *cell);
      
      //!Virtual class implemented
      void free_ref(event::Cell *cell);
};

}}

#endif

