/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 27/02/2020
 */

#include "vmp.h"
#include "pylib.h"
#include "net.h"

#ifndef VAMPIRIA_PY_NET_H

#define VAMPIRIA_PY_NET_H 1

//!Python wrapper of the c++ namespace vampiria::net in vmp_net.(see c++ doc)
/*!
    Function c++ in net/address.h:<BR>is_ipv4_raw(),is_ipv6_raw(),ip_to_buf(),ipv4_from_buf(),ipv6_from_buf(),
    is_macaddress_raw(),macaddress_to_buf(),macaddress_from_buf()
*/
/*!
    Function c++ in net/socket.h:<BR>socket_timeout()
*/
/*!
    Function c++ in net/dns.h:<BR>tcp_resolve4(),tcp_resolve6(),tcp_resolveMX()
*/
void net_init(pylib::Module module);

//!Python wrapper of the c++ class vampiria::net::Address in vmp_net.Address(see c++ doc)
/*!
    Address class in net/address.h:<BR>Constructor Address() or Address(dnstype,dnsip) or Address(dnstype,dnsip,dnsport) or Address(dnstype,dnsip,dnsport,dnstout)<BR>
    Address member function list:<BR>reset(),set(),set_ip_raw(),copy(),host(),ip(),service(),is_ipv4(),is_ipv6()
*/
void net_init_address(pylib::Module module);

//!Python wrapper of the c++ class vampiria::net::MacAddress in vmp_net.MacAddress(see c++ doc)
/*!
    MacAddress class in net/address.h:<BR>Constructor MacAddress()<BR>
    MacAddress member function list:<BR>reset(),set(),str_addr(),byte_addr()
*/
void net_init_macaddress(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::net in vmp_net.(see c++ doc)
/*!
    Function c++ in net/netdevice.h:<BR>iface_mac(),iface_ipv4(),iface_ipv4_netmask(),iface_ipv4_broadcast(),iface_ipv4_mtu()
*/
void net_init_netdevice(pylib::Module module);

//!Python wrapper of  of the c++ class vampiria::net::Udp in vmp_net.Udp(see c++ doc)
/*!
    Udp class in net/udp.h:<BR>Constructor Udp()<BR>
    Udp  member function list:<BR>reset(),socket(),block(),noblock(),set_maxpsize(),maxpsize(),get_local_address(),server(),client4(),client6(),
                                  sendTo(),recvFrom(),close()
*/
void net_init_udp(pylib::Module module);

//!Python wrapper of  of the c++ class vampiria::net::UdpUI in vmp_net.UdpUI(see c++ doc)
/*!
    Wrapper Cell->ui() for udp in udpui(cell)<BR>
    @return user interface udp ui for cell.(The cell must be built with the UdpUI user interface)
*/
/*!
    UdpUI Class in net/udp.h:<BR>Constructor UdpUI(manager)<BR>
    UdpUI member function list:<BR>set_event(),new_server(),new_client4(),new_client6(),sendTo(),maxpsize(),localaddr()
*/
void net_init_udpui(pylib::Module module);


//!Python wrapper of  of the c++ class vampiria::net::TcpClient,vampiria::net::TcpListen,vampiria::net::TcpServer in vmp_net.Tcp*(see c++ doc)
/*!
    TcpClient class in net/tcp.h:<BR>Constructor TcpClient()<BR>
    TcpClient member function list:<BR>reset(),socket(),block(),noblock(),get_local_address(),get_peer_address(),sendData(),recvData(),close(),
                                       connect(),connect_check()
*/
/*!
    TcpServer class in net/tcp.h:<BR>no Constructor<BR>
    TcpServer member function list:<BR>socket(),get_local_address(),get_peer_address(),sendData(),recvData(),close()
    
*/
/*!
    Free server connection(net/tcp.h):<BR> vmp_net.tcpserver_free_connection(server) 
*/
/*!
    TcpListen class in net/tcp.h:<BR>Constructor TcpListen()<BR>
    TcpListen member function list:<BR>reset(),socket(),block(),noblock(),get_local_address(),close(),server(),accept()
*/
void net_init_tcp(pylib::Module module);

//!Python wrapper of  of the c++ class vampiria::net::TcpUI in vmp_net.TcpUI(see c++ doc)
/*!
    Wrapper Cell->ui() for tcp in tcpui(cell)<BR>
    @return user interface tcp ui for cell.(The cell must be built with the TcpUI user interface)
*/
/*!
    TcpUI Class in net/tcp.h:<BR>Constructor TcpUI(manager)<BR>
    TcpUI member function list:<BR>set_event_client(),set_event_server(),new_client(),new_server(),send(),localaddr(),peeraddr()
*/
void net_init_tcpui(pylib::Module module);

#endif

