/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 23/09/2021
 */

#include "pylib.h"
#include "vmp.h"
#include "net.h"
#include "packet.h"
#include "json.h"

#ifndef VAMPIRIA_PY_JSON_H

#define VAMPIRIA_PY_JSON_H 1

//!Python wrapper of the c++ namespace vampiria::json in vmp_json.(see c++ doc)
/*!
    Json class in json.h:<BR>Constructor Json()<BR>
    Json member function list:<BR>root(),json_new(),json_new_obj(),json_duplicate(),parse_from_str(),
                                  parse_from_file(),json_str(),json_str_format(),json_to_file()
*/
/*!
    JsonObj class in json/json.h:<BR>Constructor JsonObj()<BR>
    JsonObj member function list:<BR>isnull(),isstr(),isbool(),isnumber(),isarray(),isobject(),
                                     keys(),get_object(),del_object(),add_object_str(),add_object_null(),
                                     add_object_bool(),add_object_number(),add_object_array(),add_object_obj(),
                                     add_object_ex(),get_array_size(),get_array_idx(),push_array_str(),push_array_null(),
                                     push_array_bool(),push_array_number(),push_array_array(),push_array_obj(),
                                     push_array_obj_ex(),replace_array_str(),replace_array_null(),replace_array_bool(),
                                     replace_array_number(),replace_array_array(),replace_array_obj(),replace_array_obj_ex(),
                                     get_object_array_strings(),get_object_array_numbers(),get_object_array_bools(),
                                     add_object_array_strings(),push_array_array_strings(),replace_array_array_strings()
                                     add_object_array_bools(),push_array_array_bools(),replace_array_array_bools(),
                                     add_object_array_numbers(),push_array_array_numbers(),replace_array_array_numbers(),
                                     add_object_array_nulls(),push_array_array_nulls(),replace_array_array_nulls()<BR>

    JsonObj member function get():<BR> function wrapper of get_str(),get_bool(),get_number() in a single function<BR>
    JsonObj member function get_object_value():<BR> function wrapper of get_object_str(),get_object_bool(),get_object_number() in a single function
*/
void json_init(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::json in vmp_json.(see c++ doc)
/*!
    JData class in json/jdata.h:<BR>Constructor JData()<BR>
    JData member function list:<BR>reset(),new_data(),set(),root(),jtype(),jkey(),set_text(),get_text(),set_integer(),
                                  get_integer(),set_integer_range(),get_integer_range(),set_real(),get_real(),
                                  set_real_range(),get_real_range(),new_list(),set_list(),get_list(),new_table(),
                                  set_table(),get_table(),set_args(),get_args(),set_vars(),get_vars(),set_custom(),
                                  get_custom(),set_buf(),get_buf(),set_netaddress(),get_netaddress(),set_macaddress(),
                                  get_macaddress(),set_packet(),get_packet()
*/
void json_jdata(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::json in vmp_json.(see c++ doc)
/*!
    JList class in json/jlist.h:<BR>Constructor JList()<BR>
    JList member function list:<BR>jdata_type(),reset(),push(),replace(),get(),size()
*/
void json_jlist(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::json in vmp_json.(see c++ doc)
/*!
    JTable class in json/jtable.h:<BR>Constructor JTable()<BR>
    JTable member function list:<BR>jdata_type(),reset(),keys(),insert(),cancel(),search()
*/
void json_jtable(pylib::Module module);

#endif

