/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/05/2020
 */

#include "event_.h"

class PyTimerUI:public event::TimerUI
{
   public:
        PyTimerUI(event::Manager *manager);
        ~PyTimerUI();

        pylib::PyCall pyevent_;
        pylib::PyCall pycevent_;
};

PyTimerUI::PyTimerUI(event::Manager *manager):event::TimerUI(manager)
{
}

PyTimerUI::~PyTimerUI()
{
}

struct stub_timerui:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            return pylib::Converter<PyTimerUI *>(cell->ui<PyTimerUI>(),false);

        }
        return 0;
    }
};

struct TimerUI_Constructor:public pylib::Constructor<PyTimerUI>
{
    PyTimerUI *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
              event::Manager *manager=args.get<event::Manager *>(0);
              return new PyTimerUI(manager);
         }
         return 0;
    }
};

void timer_pyevent(event::Cell *cell)
{
    PyTimerUI *timerui=cell->ui<PyTimerUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    timerui->pyevent_.call(cargs);
}

void timer_pycevent(event::Cell *cell)
{
    PyTimerUI *timerui=cell->ui<PyTimerUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    timerui->pycevent_.call(cargs);
}

struct stub_TimerUI_set_event:public pylib::Member_def<PyTimerUI>
{
    pylib::Objref *def(PyTimerUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            event::EVTCB event;
            event::EVTCB cevent;
            
            args.get_callable(0,instance->pyevent_);
            args.get_callable(1,instance->pycevent_);
            
            if(pylib::is_none(instance->pyevent_.ref()))
               event=0;
            else 
               event=timer_pyevent;
            if(pylib::is_none(instance->pycevent_.ref()))
               cevent=0;
            else 
               cevent=timer_pycevent;
            instance->set_event(event,cevent);
            return pylib::retnone();                      
        }
        return 0;
    }
};

void event_init_timerui(pylib::Module module)
{
    //Wrapper cell->ui()
    module.def_with_stub("timerui",stub_timerui());
    //event/ui/timerui.h
    pylib::Class<PyTimerUI> timerui=module.class_with_constructor<PyTimerUI>("TimerUI",TimerUI_Constructor());
    timerui.def_with_stub("set_event",stub_TimerUI_set_event());
    timerui.def_("new_timer",&PyTimerUI::new_timer,false);
    timerui.def_("active_timer",&PyTimerUI::active_timer);
    timerui.def_("deactive_timer",&PyTimerUI::deactive_timer);
    timerui.def_("get_timeval",&PyTimerUI::get_timeval);
    timerui.def_("id",&PyTimerUI::id);
}

