/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 10/08/2021
 */

#include "event_.h"

class PyThreadUI:public event::ThreadUI
{
   public:
        PyThreadUI(event::Manager *manager);
        ~PyThreadUI();

        pylib::PyCall pyrevent_;
        pylib::PyCall pycancel_;
        pylib::PyCall pycevent_;
};

PyThreadUI::PyThreadUI(event::Manager *manager):event::ThreadUI(manager)
{
}

PyThreadUI::~PyThreadUI()
{
}

struct stub_threadui:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            return pylib::Converter<PyThreadUI *>(cell->ui<PyThreadUI>(),false);

        }
        return 0;
    }
};

struct ThreadUI_Constructor:public pylib::Constructor<PyThreadUI>
{
    PyThreadUI *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
              event::Manager *manager=args.get<event::Manager *>(0);
              return new PyThreadUI(manager);
         }
         return 0;
    }
};

void thread_pyrevent(event::Cell *cell)
{
    PyThreadUI *threadui=cell->ui<PyThreadUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    threadui->pyrevent_.call(cargs);
}

void thread_pycancel(event::Cell *cell)
{
    PyThreadUI *threadui=cell->ui<PyThreadUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    threadui->pycancel_.call(cargs);
}

void thread_pycevent(event::Cell *cell)
{
    PyThreadUI *threadui=cell->ui<PyThreadUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    threadui->pycevent_.call(cargs);
}

struct stub_ThreadUI_set_event:public pylib::Member_def<PyThreadUI>
{
    pylib::Objref *def(PyThreadUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            event::EVTCB revent;
            event::EVTCB cancel;
            event::EVTCB cevent;
            
            args.get_callable(0,instance->pyrevent_);
            args.get_callable(1,instance->pycancel_);
            args.get_callable(2,instance->pycevent_);
            
            if(pylib::is_none(instance->pyrevent_.ref()))
               revent=0;
            else 
               revent=thread_pyrevent;
            if(pylib::is_none(instance->pycancel_.ref()))
               cancel=0;
            else 
               cancel=thread_pycancel;
            if(pylib::is_none(instance->pycevent_.ref()))
               cevent=0;
            else 
               cevent=thread_pycevent;
            instance->set_event(revent,cancel,cevent);
            return pylib::retnone();                      
        }
        return 0;
    }
};

void event_init_threadui(pylib::Module module)
{
    //Wrapper cell->ui()
    module.def_with_stub("threadui",stub_threadui());
    //event0/ui/threadui.h
    pylib::Class<PyThreadUI> threadui=module.class_with_constructor<PyThreadUI>("ThreadUI",ThreadUI_Constructor());
    threadui.def_with_stub("set_event",stub_ThreadUI_set_event());
    threadui.def_("new_thread",&PyThreadUI::new_thread);
    threadui.def_("start_thread",&PyThreadUI::start_thread);
    threadui.def_("id",&PyThreadUI::id);
}

