#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 12/02/2020

##@package vmp
#
# Wrapper c++ namespace vampiria::vmp

from vmp_ import INTMIN    as INTMIN
from vmp_ import INTMAX    as INTMAX
from vmp_ import INT16MIN  as INT16MIN
from vmp_ import INT16MAX  as INT16MAX
from vmp_ import UINTMIN   as UINTMIN
from vmp_ import UINTMAX   as UINTMAX
from vmp_ import UINT16MIN as UINT16MIN
from vmp_ import UINT16MAX as UINT16MAX
from vmp_ import CHARMIN   as CHARMIN
from vmp_ import CHARMAX   as CHARMAX
from vmp_ import UCHARMIN  as UCHARMIN
from vmp_ import UCHARMAX  as UCHARMAX
from vmp_ import RANDMAX   as RANDMAX

from vmp_ import env as env
from vmp_ import Buf as Buf

from vmp_ import except_s  as except_s

from vmp_ import init               as init
from vmp_ import io_forced_unlock   as io_forced_unlock
from vmp_ import debug              as debug
from vmp_ import info               as info
from vmp_ import warning            as warning
from vmp_ import error              as error
from vmp_ import error_raw          as error_raw
from vmp_ import output             as output
from vmp_ import output_raw         as output_raw
from vmp_ import output_file        as output_file
from vmp_ import output_file_lines  as output_file_lines
from vmp_ import input              as input
from vmp_ import input_file         as input_file
from vmp_ import input_file_s       as input_file_s
from vmp_ import exit_ok            as exit_ok
from vmp_ import exit_failure       as exit_failure

from vmp_ import system_wrap  as system_wrap
from vmp_ import pause_wrap   as pause_wrap
from vmp_ import getpid_wrap  as getpid_wrap
from vmp_ import getuid_wrap  as getuid_wrap
from vmp_ import geteuid_wrap as geteuid_wrap
from vmp_ import srand_wrap   as srand_wrap
from vmp_ import rand_wrap    as rand_wrap  

from vmp_ import fs           as fs

from vmp_ import signum       as signum
from vmp_ import sigstr       as sigstr
from vmp_ import sigcmp       as sigcmp
from vmp_ import signal_wrap  as signal_wrap

import vmp.thread             as thread

from vmp_ import time         as time

from vmp_ import unicode      as unicode

from vmp_ import utils        as utils

##Global instance class 
class Instance:
  ##A constructor  
  def __init__(self):
    self.obj=None

  ##set global data object<BR>
  #
  # @param obj global data object  
  def set_global(self,obj):
    self.obj=obj

  ## Returns global data object
  #
  # @return global data object  
  def get_global(self):
    return self.obj

##shared instance class
instance_=Instance()

##input arguments of the process
input_={}

##input function exec<BR>
#
#@param name input name<BR>
#@param f function(parlist,varlist) to exec for any input name
def input_f(name,f):
  try:
    if name in input_:
      ilist=input_[name]
      for value in ilist:
        f(value[0],value[1])
  except Exception as e:
    except_s(str(e))

def external_module_error(name):
  except_s("Python Module \'{0}\' not found,install it.".format(name))

try:
    import signal
except:
    external_module_error("signal")

##native python signal management
#
#@param lsignal signal list in string format(["sigint",...])
#@param sighandler callback signal(def handler(signum, frame))
def signal_py(lsignal,sighandler):
  for s in lsignal:
    try:
      sig=signum(s)
    except Exception as x:
      except_s("Argument 1 error(Invalid input type \'{0}\')".format(str(x))) 
    signal.signal(sig,sighandler)


