#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 31/12/2019

import vmpsys    as sys
import vmpconfig as config
import vmpbuild  as build
import vmpcheck  as check

##python library installed
pylibs_={}

##Check and install python dependencies(internal python lib)<BR>
#
#@param depends dependencies list<BR>
#@param pysetup generic class pysetup value
def pydependencies(depends,pysetup):
  if not 'vmp' in pysetup.deprun:
    pylibs_['vmp'].install(pysetup)
  for d in depends:
    if d in pylibs_:
      if not d in pysetup.deprun:
        pylibs_[d].install(pysetup)
    else:
      sys.msg_failure("Pylib \'{0}\'".format(d),'not found')

##Library installer Python Object 
class pylib:
  def __init__(self):
    ##Library name
    self.name=''
    ##Internal python library dependencies ['vmp',...]
    self.dependencies=[]
    ##Command external ['ls -l',...]
    self.cmd=[]
    ##Is it an external package to the framework?
    self.pkg=False
    ##Build c++ shared object python(wrapper c++ to python)
    self.setup=None

  ##Build cpp object for wrapper c++->python(it must be called after setting the parameters of the python package)
  def cbuild(self):
    self.setup=build.setup()
    self.setup.name="{0}_".format(self.name)
    self.setup.shared=True
    if self.pkg:
      self.setup.path=config.pysrc_(self.name,config.gvpkg_)
    else:
      self.setup.path=config.pysrc_(self.name,config.fwpylib_)
    self.setup.dirtarget=config.fwpylibso_   

  ##Install library<BR>
  #
  #@param pysetup generic class pysetup value
  def install(self,pysetup):
    pysetup.deprun[self.name]=self
    pysobj="{0}{1}_.so".format(sys.path(config.fwpylibso_),self.name)
    if not sys.isfile(pysobj):
      if self.setup is None:
        sys.write_file(pysobj,'')
      else:
        build.cbuild(self.setup)  
      pydependencies(self.dependencies,pysetup)
      for c in self.cmd:
        sys.search_cmd(c.split())
    try:
      check.pylibtest(self.name)
    except Exception as e:
      sys.msg_failure("Build Python lib \'{0}\'\n".format(self.name),e)
    sys.msg_ok("Build Python Lib \'{0}\'".format(self.name))

  ##Remove library
  def clear(self):
    pyobj="{0}{1}_.so".format(sys.path(config.fwpylibso_),self.name)
    if sys.isfile(pyobj):
      sys.rm_file(pyobj)
    if self.setup is not None:
      if self.pkg:
        rootpath=sys.path(config.pysrc_(self.name,config.gvpkg_))
      else:
        rootpath=sys.path(config.pysrc_(self.name,config.fwpylib_))
      sys.rm_cobj(rootpath,self.setup.files)
      
##Remove all python library installed   
def clear():
  for name in pylibs_:
     pylibs_[name].clear()

vmp=pylib()
vmp.name='vmp'
vmp.cbuild()
vmp.setup.files=[('./',['buf_','env_','fs_','thread_','time_','unicode_','utils_','vmp_'])]
vmp.setup.dependencies=['vmp','pylib']
pylibs_[vmp.name]=vmp

event=pylib()
event.name="vmp_event"
event.dependencies=[]
event.cbuild()
event.setup.files=[('./',['event_','inputui_','simplexui_','threadui_','timerui_'])]
event.setup.dependencies=['pylib','event','vmp']
pylibs_[event.name]=event

net=pylib()
net.name='vmp_net'
net.cbuild()
net.setup.files=[('./',['address_','macaddress_','net_','netdevice_','tcp_','udp_'])]
net.setup.dependencies=['vmp','pylib','net']
pylibs_[net.name]=net

xml=pylib()
xml.name='vmp_xml'
xml.cbuild()
xml.setup.files=[('./',['xml_','wparser_','parser_'])]
xml.setup.dependencies=['vmp','pylib','xml']
pylibs_[xml.name]=xml

packet=pylib()
packet.name='vmp_packet'
packet.cbuild()
packet.setup.files=[('./',['packet_'])]
packet.setup.dependencies=['vmp','pylib','packet']
pylibs_[packet.name]=packet

plugin=pylib()
plugin.name='vmp_plugin'
plugin.dependencies=[]
pylibs_[plugin.name]=plugin

json=pylib()
json.name='vmp_json'
json.cbuild()
json.setup.files=[('./',['json_','jdata_','jlist_','jtable_'])]
json.setup.dependencies=['vmp','pylib','json','net','packet']
pylibs_[json.name]=json


