#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 19/02/2020

import vmplib    as lib
import vmpsys    as sys
import vmpconfig as config

##Setup C++ installer object(software or libs)
class setup:
  def __init__(self):
    ##Object name
    self.name=''
    ##root path source
    self.path=''
    ##Files to compile [('directory files',['file1',...]),...]
    self.files=[]
    ##Internal library or package dependencies ['vmp',...]
    self.dependencies=[]
    ##Compiler Options ['`pkg-config --cflags python3`',...]
    self.coptions=[]
    ##Linker options ['`pkg-config --libs python3`',...]
    self.loptions=[]
    ## False exe file,true .so library
    self.shared=False
    ##directory to make exe or .so files
    self.dirtarget=''
    ##Command external ['ls -l',...]
    self.cmd=[]
    ##Header included ['stdio.h'...]
    self.hdr=[]
    ##External library [('extlibname','min version'),...]
    self.libs=[]
    ##internal usage
    self.sobject=[]
    ##Internal use to avoid entering multiple dependencies of the same type
    self.deprun={}
    ##Config file create (filename,['string list one a line',...])
    self.config=()

##Build c++ software<BR>
#
#@param setup object setup
def cbuild(setup):
  lib.dependencies(setup.dependencies,setup)
  lib.check(setup.cmd,setup.hdr,setup.libs)
  try:
    setup.sobject= sys.compiler(sys.path(setup.path),config.cpp_(lib.included_,setup.coptions),setup.files) + setup.sobject
    if setup.shared:
      linker=config.cppso_()
      sobj="{0}{1}.so".format(sys.path(setup.dirtarget),setup.name)
    else:
      linker=config.cppbin_()
      sobj="{0}{1}".format(sys.path(setup.dirtarget),setup.name)  
    sys.linker(sys.path(setup.path),linker,setup.sobject,setup.loptions,sobj)
  except Exception as e:
    sys.msg_failure("Build \'{0}\'".format(setup.name),e)
  if setup.shared:
    sys.msg_ok("Build shared object \'{0}.so\'".format(setup.name))
  else:
    sys.msg_ok("Build program \'{0}\'".format(setup.name))  

##Clear c++ software<BR>
#
#@param setup object setup 
def cclear(setup):
  if setup.shared:
    obj="{0}{1}.so".format(sys.path(setup.dirtarget),setup.name)
  else:
    obj="{0}{1}".format(sys.path(setup.dirtarget),setup.name)
  if sys.isfile(obj):
    rootpath="{0}".format(sys.path(setup.path))
    sys.rm_cobj(rootpath,setup.files)
    sys.rm_file(obj)
   
##Build symbolic link external lib<BR>
#
#@param libname link name<BR>
#@param example example string in output
def symlink_lib_build(libname,example):
  sys.stdout("Insert path source link[ex:{0}]:".format(example));
  value = sys.stdin()
  if value == "":
    sys.msg_failure("Build symlink {0}".format(libname),"Empty input received")
  libpath="{0}{1}.so".format(sys.path(config.glib_),libname)
  if not sys.isfile(value):
    sys.msg_failure("Build symlink {0}->{1}".format(value,libpath),"invalid input value")
  sys.system("ln -sf {0} \"{1}\"".format(value,libpath))
  sys.msg_ok("Build symlink {0}->{1}".format(value,libpath))

##Deletes symbolic link external lib<BR>
#
#@param libname symbolic link name<BR>
def symlink_lib_clear(libname):
  libpath="{0}{1}.so".format(sys.path(config.glib_),libname)
  sys.rm_file(libpath)
  
