/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 10/08/2021
 */
 
#include "rawnet_.h"

VAMPIRIA_PYLIB_INIT(vmp_rawnet1_);

void rawnet_init(pylib::Module module)
{
    pylib::Class<rawnet::pkg::Dumper> dumper=module.class_<rawnet::pkg::Dumper>("Dumper");
    dumper.def_("open",&rawnet::pkg::Dumper::open);
    dumper.def_("dump",&rawnet::pkg::Dumper::dump);
    dumper.def_("close",&rawnet::pkg::Dumper::close);
	
    pylib::Class<rawnet::pkg::Offline> offline=module.class_<rawnet::pkg::Offline>("Offline");
    offline.def_("reset",&rawnet::pkg::Offline::reset);
    offline.def_("read",&rawnet::pkg::Offline::read);
    offline.def_("data_size",&rawnet::pkg::Offline::data_size);
    offline.def_("get",&rawnet::pkg::Offline::get,false);
	
    module.def_("filter_file",rawnet::pkg::filter_file);
    module.def_("linktype_str_generic",rawnet::pkg::linktype_str_generic);
    module.def_("linktype_str",rawnet::pkg::linktype_str);
}

void vampiria_pylib_init_module(pylib::Module init_module)
{
     rawnet_init(init_module);
     rawnet_rawui(init_module);
}

