#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 02/12/2020

import vmp
import vmp_plugin as plugin

PluginName="base_formatio"

class Plugin(plugin.formatio.Plugin):
  def __init__(self,data,options):
    plugin.formatio.Plugin.__init__(self,data,options)
    	  
  def input(self):
    try:
      return vmp.input()
    except Exception as e:
      vmp.except_s("base_formatio::input() {0}".format(str(e))) 

  def output(self,value):
    vmp.output(value)

  def output_raw(self,value):
    vmp.output_raw(value)

class PluginTopic(plugin.formatio.PluginTopic):
  def __init__(self,modname,plugname):
    plugin.formatio.PluginTopic.__init__(self,modname,plugname)
    self.set_desc("Reads and writes data to standard inputs and outputs(throw exception error)")
    self.set_function("input","Read data from standard input and return the read string")
    self.set_function("output","It takes a string as input and writes it to standard output")
    self.set_function("output_raw","It takes a string as input and writes it to standard output in raw mode")
    
