#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 28/11/2020

import vmp
import vmp_plugin as plugin

PluginName="base_format"

class Plugin(plugin.format.Plugin):
  def __init__(self,data,options):
    plugin.format.Plugin.__init__(self,data,options)
    self.delimiter=self.opt_get("delimiter",0,'')
    try:
      if not ((len(self.delimiter) % 2) == 0):  
        vmp.except_s("")
      self.delimiter=vmp.unicode.xstr_tostr(self.delimiter,'')
    except:
      self.opt_err("delimiter")
    
  def format(self,strinput):
    return strinput

  def rformat(self,strinput):
    return strinput

  def format_list(self,strlist):
    return strlist

  def rformat_list(self,strlist):
    return strlist

  def format_str_tolist(self,strinput):
    return vmp.unicode.str_split(strinput,self.delimiter)

  def rformat_str_tolist(self,strinput):
    return self.format_str_tolist(strinput)

  def format_list_tostr(self,strlist):
    return vmp.unicode.str_join(strlist,self.delimiter)
    
  def rformat_list_tostr(self,strlist):
    return self.format_list_tostr(strlist)

class PluginTopic(plugin.format.PluginTopic):
  def __init__(self,modname,plugname):
    plugin.format.PluginTopic.__init__(self,modname,plugname)
    self.set_desc("Perform basic operations on strings (split, join).")
    self.set_function("format","It takes an input string and returns it unchanged")
    self.set_function("rformat","see format")
    self.set_function("format_list","It takes a list of strings as input and returns it unchanged")
    self.set_function("rformat_list","see format_list")
    self.set_function("format_str_tolist","Split the input string and return the list of calculated values.Use the delimiter option as a delimiter for the split.")
    self.set_function("rformat_str_tolist","see format_str_tolist")
    self.set_function("format_list_tostr","Joins the values of the input string list and returns the created string.Use the delimiter option as a delimiter for the join.")
    self.set_function("rformat_list_tostr","see format_list_tostr")
    self.add_option("delimiter","empty string","1",
                            "String used as a delimiter for split and join operations.The string must be entered in hexadecimal format with each byte consisting of two positions. Example the string 'aa' must be entered as 6161")

