/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 10/08/2021
 */

#ifndef VAMPIRIA_RAWNET_PKG_RAWEVENT_H

#define VAMPIRIA_RAWNET_PKG_RAWEVENT_H 1

namespace vampiria { namespace rawnet { namespace pkg {

//!Event associated with raw socket operations. (See in framework event package)
class EventRawNet:public event::EventThread
{
    public:
        //! A constructor
        EventRawNet();

        //! A destructor
        ~EventRawNet();

        //! Reset all
        void evt_rawnet_reset();

        rawnet::pkg::rawnet_t rawnet_;/*<! raw handler_*/
        vmp::str ifname_;/*!< interface name associated with the event*/
        vmp::str filter_;/*!<filter (see pcap_filetr)associated with the event*/
        vmp_bool isread_;/*!<the event is also being read*/
        vmp_int  linktype_;/*!<linktype in integer format*/
        vmp::str linktype_str_;/*!<linktype in string format*/
        net::EVTCBRECV recv_;/*!<Recv packet callback*/

        //! Returns interface name
        /*!
            @sa ifname_
            @return interface name
        */
        vmp::str evt_rawnet_iface();

        //! Returns filter used
        /*!
            @sa filter_
            @return filter used
        */
        vmp::str evt_rawnet_filter();

        //! It tells us if the event is in write mode or read and write mode
        /*!
            @sa isread_;
            @return "readwrite" or "writeonly"
        */
        vmp::str evt_rawnet_mode();

        //! Returns linktype in interger format
        /*!
            @sa linktype_
            @return link type
        */
        vmp_int  evt_rawnet_linktype();

        //! Returns linktype in string format
        /*!
            @sa linktype_str_
            @return link type
        */
        vmp::str evt_rawnet_linktype_str();
       
        //!Create an event in mode "readwrite"(Use evt_rawnet_loop() after cell initialization to start the read loop)
        /*!
            @param ui user interface
            @param ifname interface name
            @param filter pcap filter
            @param recv recv data callback
            @param close close event callback
        */
        event::Cell *evt_rawnet_rw_new(event::UI *ui,vmp::str ifname,vmp::str filter,net::EVTCBRECV recv,event::EVTCB close);
        
        //!Create an event in mode "writeonly"
        /*!
            @param ui user interface
            @param ifname interface name
            @param close close event callback
        */
        event::Cell *evt_rawnet_w_new(event::UI *ui,vmp::str ifname,event::EVTCB close);
        
        //! Starting reading loop(only readwrite mode)
        void evt_rawnet_loop();

        //!Injects a packet into the raw socket
        /*!
            @param buf input buffer
        */
        void evt_rawnet_inject(vmp::Buf *buf);
        
        //! Close event
        void evt_rawnet_close();

        //! Free event
        void evt_rawnet_free();
};

}}}

#endif

