/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 08/11/2020
 */

#include <cmath>
#include <ctgmath>

namespace vampiria { namespace vmp { namespace math {

//!Returns the value of x raised to the power of y
/*!
    @param x base
    @param y exponent
    @return value of x raised to the power of
*/
vmp_real pow_wrap(vmp_real x,vmp_real y);

//!Computes the 1's complement of the 16-bit ones complement sum of the buffer values.
//!If the buffer length is odd it adds a 0x00 byte to the end
/*!
    @param buf input buf
    @return checksum16 value
*/
vmp_uint16 checksum16(vmp::Buf *buf);

//!See checksum16
/*!
    @param buf input buf
    @return checksum16 in exa string("XXXX" 4 position)
*/
vmp::str checksum16_str(vmp::Buf *buf);

}}}

