/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 05/02/2020
 */

#ifndef VAMPIRIA_PYLIB_STUBMEMBER_H

#define VAMPIRIA_PYLIB_STUBMEMBER_H 1

namespace vampiria { namespace pylib {

template<class Wrap,class Fn>
struct Member_default:public Member_def<Wrap>
{
    Fn fn_;
    vmp_size arity_;
    typedef vmp::function<Fn> func_;
    typedef typename pylib::Signature<func_>::arg0_t arg0_t;
    typedef typename pylib::Signature<func_>::arg1_t arg1_t;
    typedef typename pylib::Signature<func_>::arg2_t arg2_t;
    typedef typename pylib::Signature<func_>::arg3_t arg3_t;
    typedef typename pylib::Signature<func_>::arg4_t arg4_t;

    vmp_bool retfree_;
    
    Member_default(Fn fn,vmp_bool retfree)
    {
        static_assert(pylib::Signature<func_>::Arity_ <= VMP_PYLIB_MAX_DEFSTUBARITY,"Overflow Max Arity in default member def signature");
        arity_=Signature<func_>::Arity_;
        fn_=fn;
        retfree_=retfree;
    }

    pylib::Objref *def(Wrap *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == arity_)
        {
            arg0_t arg0;
            arg1_t arg1;
            arg2_t arg2;
            arg3_t arg3;
            arg4_t arg4;
            for(vmp_index i=0;i<arity_;i++)
            {
                switch(i)
                {
                    case 0:arg0=args.get<arg0_t>(0);break;
                    case 1:arg1=args.get<arg1_t>(1);break;
                    case 2:arg2=args.get<arg2_t>(2);break;
                    case 3:arg3=args.get<arg3_t>(3);break;
                    case 4:arg4=args.get<arg4_t>(4);break;
                }
            }
            return pylib::Signature<func_>::invoke(instance,fn_,arg0,arg1,arg2,arg3,arg4,retfree_);
        }
        return 0;
    } 
};

}}

#endif

