/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 22/01/2020
 */

#include "pylib.h"

namespace vampiria { namespace pylib {

pylib::Objref *retnone()
{
    pylib::incref( Py_None);
    return  Py_None;
}

Objbase::Objbase(pylib::Objref *ref,vmp::str name,vmp::str prefix)
{
     ref_=ref;
     name_=name;
     prefix_=prefix;	
}
        
Objbase::~Objbase()
{
    ref_=0;
    name_.clear();
    prefix_.clear();
}

pylib::Objref *Objbase::ref()
{
     return ref_;	
}

vmp::str Objbase::fullname()
{
     if(prefix_== "")
        return name_;
     vmp::str fullname;
     vmp::unicode::str_write(&fullname,"%s.%s",prefix_.c_str(),name_.c_str());
     return fullname; 
}

}}
