/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/05/2020
 */

#ifndef VAMPIRIA_EVENT_EVENTSIMPLEX_H

#define VAMPIRIA_EVENT_EVENTSIMPLEX_H 1

namespace vampiria { namespace event {

//!Event simplex
class EventSimplex:public event::EventPipe
{
    private:
        
    public:
        //!A Constructor
        EventSimplex();

        //!A Destructor
        ~EventSimplex();

        event::EVTCB active_;/*!<callback performed on active event*/

        //!Create Simplex Event
        /*!
            @param ui ui user interface (see Class UI)
            @param active callback performed on active event
            @param close function performed at the end of the event
            @return the new cell associated with the event
        */
        event::Cell *evt_simplex_new(event::UI *ui,event::EVTCB active,event::EVTCB close);

        //!Active simplex event
        void evt_simplex_active();

        //! Close simplex event
        void evt_simplex_close();

        //! Free simplex event
        void evt_simplex_free();
};

}}

#endif

