/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/05/2020
 */

#include "event.h"

namespace vampiria { namespace event {

void simplex_ev(event::Cell *cell)
{
    vmp_bool exec=false;
    event::Manager *manager=cell->get_manager();
    EventSimplex *event=cell->event<EventSimplex>();
    manager->lock();
    vmp_byte byte;
    try
    {
        if(vmp::fd_read_bytes(event->fd_,&byte,1) == 1)
            exec=manager->cell_update(cell);
    }
    catch(vmp::exception &x)
    {
        manager->cell_close(cell,event::ERROR,x.what());
    }
    manager->unlock();   
    if(exec)
        event->active_(cell);
}

EventSimplex::EventSimplex():event::EventPipe()
{
}
       
EventSimplex::~EventSimplex()
{
}

event::Cell *EventSimplex::evt_simplex_new(event::UI *ui,event::EVTCB active,event::EVTCB close)
{
    event::Cell *cell=evt_pipe_new(ui,simplex_ev,close);
    if(active == 0)
        active_=event::empty_ev;
    else
        active_=active;
    return cell;
}

void EventSimplex::evt_simplex_active()
{
    try
    {
        vmp_byte b=0x00;
        vmp::fd_write_bytes(wfd_,&b,1);
    }
    catch(vmp::exception &x)
    {
    }
}

void EventSimplex::evt_simplex_close()
{
    evt_pipe_close();
}

void EventSimplex::evt_simplex_free()
{
    active_=0;
    evt_pipe_free();
}

}}

