#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 26/11/2020

import vmp_plugin.base as base

ptype_="formatio"
input_f_="input"
output_f_="output"
output_raw_f_="output_raw"

##Plugin interface used for input and output operations.
class Plugin(base.Plugin):
  def __init__(self,data,options):
    base.Plugin.__init__(self,ptype_,data,0,options)
    
  ##Reads an input value and returns the formatted string
  def input(self):
    self.not_implemented(input_f_)

  ##It takes a string as input and writes a formatted string to output
  def output(self,value):
    self.not_implemented(output_f_)

  ##It takes a string as input and writes a formatted string to output in raw mode
  def output_raw(self,value):
    self.not_implemented(output_raw_f_)


##Plugin interface topic
class PluginTopic(base.PluginTopic):
  def __init__(self,modname,plugname):
    base.PluginTopic.__init__(self,ptype_,modname,plugname)
    self.set_desc("Plugin interface used for input and output operations")
    self.add_function(input_f_,"Reads an input value and returns the formatted string(not implemented)")
    self.add_function(output_f_,"It takes a string as input and writes a formatted string to output(not implemented)")
    self.add_function(output_raw_f_,"It takes a string as input and writes a formatted string to output in raw mode(not implemented)")
    
    

